/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBase;

@PublicEvolving
public class CatalogColumnStatisticsDataBinary
extends CatalogColumnStatisticsDataBase {
    private final Long maxLength;
    private final Double avgLength;

    public CatalogColumnStatisticsDataBinary(Long maxLength, Double avgLength, Long nullCount) {
        super(nullCount);
        this.maxLength = maxLength;
        this.avgLength = avgLength;
    }

    public CatalogColumnStatisticsDataBinary(Long maxLength, Double avgLength, Long nullCount, Map<String, String> properties) {
        super(nullCount, properties);
        this.maxLength = maxLength;
        this.avgLength = avgLength;
    }

    public Long getMaxLength() {
        return this.maxLength;
    }

    public Double getAvgLength() {
        return this.avgLength;
    }

    @Override
    public CatalogColumnStatisticsDataBinary copy() {
        return new CatalogColumnStatisticsDataBinary(this.maxLength, this.avgLength, this.getNullCount(), new HashMap<String, String>(this.getProperties()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogColumnStatisticsDataBinary that = (CatalogColumnStatisticsDataBinary)o;
        return Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.avgLength, that.avgLength) && Objects.equals(this.getNullCount(), that.getNullCount());
    }

    public int hashCode() {
        return Objects.hash(this.maxLength, this.avgLength, this.getNullCount());
    }

    public String toString() {
        return "CatalogColumnStatisticsDataBinary{maxLength=" + this.maxLength + ", avgLength=" + this.avgLength + ", nullCount=" + this.getNullCount() + '}';
    }
}

