/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

final class StrategyUtils {
    static Optional<DataType> findDataType(CallContext callContext, boolean throwOnFailure, DataType actualDataType, LogicalTypeRoot expectedRoot, @Nullable Boolean expectedNullability) {
        LogicalType actualType = actualDataType.getLogicalType();
        return Optional.ofNullable(StrategyUtils.findDataTypeOfRoot(actualDataType, expectedRoot)).map(newDataType -> {
            if (Objects.equals(expectedNullability, Boolean.TRUE)) {
                return (DataType)newDataType.nullable();
            }
            if (Objects.equals(expectedNullability, Boolean.FALSE)) {
                return (DataType)newDataType.notNull();
            }
            if (actualType.isNullable()) {
                return (DataType)newDataType.nullable();
            }
            return (DataType)newDataType.notNull();
        }).map(newDataType -> {
            Class<?> clazz = actualDataType.getConversionClass();
            LogicalType newType = newDataType.getLogicalType();
            if (newType.supportsOutputConversion(clazz)) {
                return (DataType)newDataType.bridgedTo(clazz);
            }
            return newDataType;
        }).filter(newDataType -> {
            if (LogicalTypeCasts.supportsImplicitCast(actualType, newDataType.getLogicalType())) {
                return true;
            }
            if (throwOnFailure) {
                throw callContext.newValidationError("Unsupported argument type. Expected type root '%s' but actual type was '%s'.", new Object[]{expectedRoot, actualType});
            }
            return false;
        });
    }

    static boolean isDecimalComputation(LogicalType type1, LogicalType type2) {
        if (!LogicalTypeChecks.hasFamily(type1, LogicalTypeFamily.EXACT_NUMERIC) || !LogicalTypeChecks.hasFamily(type2, LogicalTypeFamily.EXACT_NUMERIC)) {
            return false;
        }
        return LogicalTypeChecks.hasRoot(type1, LogicalTypeRoot.DECIMAL) || LogicalTypeChecks.hasRoot(type2, LogicalTypeRoot.DECIMAL);
    }

    @Nullable
    private static DataType findDataTypeOfRoot(DataType actualDataType, LogicalTypeRoot expectedRoot) {
        LogicalType actualType = actualDataType.getLogicalType();
        if (LogicalTypeChecks.hasRoot(actualType, expectedRoot)) {
            return actualDataType;
        }
        switch (expectedRoot) {
            case CHAR: {
                return DataTypes.CHAR(1);
            }
            case VARCHAR: {
                if (LogicalTypeChecks.hasRoot(actualType, LogicalTypeRoot.CHAR)) {
                    return DataTypes.VARCHAR(LogicalTypeChecks.getLength(actualType));
                }
                return DataTypes.VARCHAR(1);
            }
            case BOOLEAN: {
                return DataTypes.BOOLEAN();
            }
            case BINARY: {
                return DataTypes.BINARY(1);
            }
            case VARBINARY: {
                if (LogicalTypeChecks.hasRoot(actualType, LogicalTypeRoot.BINARY)) {
                    return DataTypes.VARBINARY(LogicalTypeChecks.getLength(actualType));
                }
                return DataTypes.VARBINARY(1);
            }
            case DECIMAL: {
                if (LogicalTypeChecks.hasFamily(actualType, LogicalTypeFamily.EXACT_NUMERIC)) {
                    return DataTypes.DECIMAL(LogicalTypeChecks.getPrecision(actualType), LogicalTypeChecks.getScale(actualType));
                }
                if (LogicalTypeChecks.hasFamily(actualType, LogicalTypeFamily.APPROXIMATE_NUMERIC)) {
                    int precision = LogicalTypeChecks.getPrecision(actualType);
                    return DataTypes.DECIMAL(precision * 2, precision);
                }
                return DataTypes.DECIMAL(1, 0);
            }
            case TINYINT: {
                return DataTypes.TINYINT();
            }
            case SMALLINT: {
                return DataTypes.SMALLINT();
            }
            case INTEGER: {
                return DataTypes.INT();
            }
            case BIGINT: {
                return DataTypes.BIGINT();
            }
            case FLOAT: {
                return DataTypes.FLOAT();
            }
            case DOUBLE: {
                return DataTypes.DOUBLE();
            }
            case DATE: {
                return DataTypes.DATE();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                if (LogicalTypeChecks.hasRoot(actualType, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
                    return DataTypes.TIME(LogicalTypeChecks.getPrecision(actualType));
                }
                return DataTypes.TIME();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return DataTypes.TIMESTAMP();
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return DataTypes.TIMESTAMP_WITH_TIME_ZONE();
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE();
            }
            case INTERVAL_YEAR_MONTH: {
                return DataTypes.INTERVAL(DataTypes.MONTH());
            }
            case INTERVAL_DAY_TIME: {
                return DataTypes.INTERVAL(DataTypes.SECOND());
            }
            case NULL: {
                return DataTypes.NULL();
            }
        }
        return null;
    }

    private StrategyUtils() {
    }
}

