/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical.utils;

import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class LogicalTypeMergingTest {
    @Test
    public void testFindDivisionDecimalType() {
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findDivisionDecimalType((int)32, (int)8, (int)38, (int)8), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(38, 6)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findDivisionDecimalType((int)30, (int)20, (int)30, (int)20), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(38, 8)));
    }

    @Test
    public void testFindMultiplicationDecimalType() {
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findMultiplicationDecimalType((int)30, (int)10, (int)30, (int)10), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(38, 6)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findMultiplicationDecimalType((int)30, (int)20, (int)30, (int)20), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(38, 17)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findMultiplicationDecimalType((int)38, (int)2, (int)38, (int)3), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(38, 5)));
    }

    @Test
    public void testFindModuloDecimalType() {
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findModuloDecimalType((int)30, (int)10, (int)30, (int)10), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(30, 10)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findModuloDecimalType((int)30, (int)20, (int)25, (int)20), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(25, 20)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findModuloDecimalType((int)10, (int)10, (int)10, (int)10), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(10, 10)));
    }

    @Test
    public void testFindAdditionDecimalType() {
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findAdditionDecimalType((int)38, (int)8, (int)32, (int)8), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(38, 7)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findAdditionDecimalType((int)32, (int)8, (int)38, (int)8), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(38, 7)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findAdditionDecimalType((int)30, (int)20, (int)28, (int)20), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(31, 20)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findAdditionDecimalType((int)10, (int)10, (int)10, (int)10), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(11, 10)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findAdditionDecimalType((int)38, (int)5, (int)38, (int)4), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(38, 5)));
    }

    @Test
    public void testFindRoundingDecimalType() {
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findRoundDecimalType((int)32, (int)8, (int)5), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(30, 5)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findRoundDecimalType((int)32, (int)8, (int)10), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(32, 8)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findRoundDecimalType((int)30, (int)20, (int)18), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(29, 18)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findRoundDecimalType((int)10, (int)10, (int)2), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(3, 2)));
    }

    @Test
    public void testFindAvgAggType() {
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findAvgAggType((LogicalType)LogicalTypeMergingTest.decimal(38, 20)), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(38, 20)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findAvgAggType((LogicalType)LogicalTypeMergingTest.decimal(38, 2)), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(38, 6)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findAvgAggType((LogicalType)LogicalTypeMergingTest.decimal(38, 8)), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(38, 8)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findAvgAggType((LogicalType)LogicalTypeMergingTest.decimal(30, 20)), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(38, 20)));
        MatcherAssert.assertThat((Object)LogicalTypeMerging.findAvgAggType((LogicalType)LogicalTypeMergingTest.decimal(10, 10)), (Matcher)CoreMatchers.equalTo((Object)LogicalTypeMergingTest.decimal(38, 10)));
    }

    private static final DecimalType decimal(int precision, int scale) {
        return new DecimalType(false, precision, scale);
    }
}

