/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;

public class TypeTestingUtils {
    public static Matcher<DataType> hasLogicalType(LogicalType logicalType) {
        return new FeatureMatcher<DataType, LogicalType>(CoreMatchers.equalTo((Object)logicalType), "logical type of the data type", "logical type"){

            protected LogicalType featureValueOf(DataType actual) {
                return actual.getLogicalType();
            }
        };
    }

    public static Matcher<DataType> hasConversionClass(Class<?> clazz) {
        return new FeatureMatcher<DataType, Class<?>>(CoreMatchers.equalTo(clazz), "conversion class of the data type", "conversion class"){

            protected Class<?> featureValueOf(DataType actual) {
                return actual.getConversionClass();
            }
        };
    }

    public static Matcher<DataType> hasNullability(boolean isNullable) {
        return new FeatureMatcher<DataType, Boolean>(CoreMatchers.equalTo((Object)isNullable), "nullability of the data type", "nullability"){

            protected Boolean featureValueOf(DataType actual) {
                return actual.getLogicalType().isNullable();
            }
        };
    }
}

