/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorBase;
import org.apache.flink.table.descriptors.DescriptorProperties;

@PublicEvolving
public abstract class ConnectorDescriptor
extends DescriptorBase
implements Descriptor {
    private String type;
    private int version;
    private boolean formatNeeded;

    public ConnectorDescriptor(String type, int version, boolean formatNeeded) {
        this.type = type;
        this.version = version;
        this.formatNeeded = formatNeeded;
    }

    @Override
    public final Map<String, String> toProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("connector.type", this.type);
        properties.putLong("connector.property-version", this.version);
        properties.putProperties(this.toConnectorProperties());
        return properties.asMap();
    }

    protected final boolean isFormatNeeded() {
        return this.formatNeeded;
    }

    protected abstract Map<String, String> toConnectorProperties();
}

