/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.sources.ProjectableTableSource;
import org.apache.flink.table.sources.TableSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class TableSourceTestBase {
    protected abstract TableSource<?> createTableSource(TableSchema var1);

    @Test
    public void testEmptyProjection() {
        TableSource<?> source = this.createTableSource(TableSchema.builder().field("f0", DataTypes.INT()).build());
        Assume.assumeThat(source, (Matcher)CoreMatchers.instanceOf(ProjectableTableSource.class));
        ProjectableTableSource projectableTableSource = (ProjectableTableSource)source;
        TableSource newTableSource = projectableTableSource.projectFields(new int[0]);
        Assert.assertThat((Object)newTableSource.explainSource(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)source.explainSource())));
    }

    @Test
    public void testProjectionReturnsDifferentSource() {
        TableSource<?> source = this.createTableSource(TableSchema.builder().field("f0", DataTypes.INT()).field("f1", DataTypes.STRING()).field("f2", DataTypes.BIGINT()).build());
        Assume.assumeThat(source, (Matcher)CoreMatchers.instanceOf(ProjectableTableSource.class));
        ProjectableTableSource projectableTableSource = (ProjectableTableSource)source;
        TableSource newTableSource = projectableTableSource.projectFields(new int[]{0, 2});
        Assert.assertThat((Object)newTableSource.explainSource(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)source.explainSource())));
        Assert.assertThat((Object)newTableSource.getTableSchema(), (Matcher)CoreMatchers.equalTo((Object)source.getTableSchema()));
    }
}

