/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.stats;

import java.util.HashMap;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.junit.Assert;
import org.junit.Test;

public class TableStatsTest {
    @Test
    public void testMerge() {
        HashMap<String, ColumnStats> colStats1 = new HashMap<String, ColumnStats>();
        colStats1.put("a", new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Number)15, (Number)2));
        TableStats stats1 = new TableStats(30L, colStats1);
        HashMap<String, ColumnStats> colStats2 = new HashMap<String, ColumnStats>();
        colStats2.put("a", new ColumnStats(Long.valueOf(3L), Long.valueOf(15L), Double.valueOf(12.0), Integer.valueOf(23), (Number)35, (Number)6));
        TableStats stats2 = new TableStats(32L, colStats2);
        HashMap<String, ColumnStats> colStatsMerge = new HashMap<String, ColumnStats>();
        colStatsMerge.put("a", new ColumnStats(Long.valueOf(7L), Long.valueOf(20L), Double.valueOf(7.0), Integer.valueOf(23), (Number)35, (Number)2));
        Assert.assertEquals((Object)new TableStats(62L, colStatsMerge), (Object)stats1.merge(stats2));
    }

    @Test
    public void testMergeLackColumnStats() {
        HashMap<String, ColumnStats> colStats1 = new HashMap<String, ColumnStats>();
        colStats1.put("a", new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Number)15, (Number)2));
        colStats1.put("b", new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Number)15, (Number)2));
        TableStats stats1 = new TableStats(30L, colStats1);
        HashMap<String, ColumnStats> colStats2 = new HashMap<String, ColumnStats>();
        colStats2.put("a", new ColumnStats(Long.valueOf(3L), Long.valueOf(15L), Double.valueOf(12.0), Integer.valueOf(23), (Number)35, (Number)6));
        TableStats stats2 = new TableStats(32L, colStats2);
        HashMap<String, ColumnStats> colStatsMerge = new HashMap<String, ColumnStats>();
        colStatsMerge.put("a", new ColumnStats(Long.valueOf(7L), Long.valueOf(20L), Double.valueOf(7.0), Integer.valueOf(23), (Number)35, (Number)2));
        Assert.assertEquals((Object)new TableStats(62L, colStatsMerge), (Object)stats1.merge(stats2));
    }

    @Test
    public void testMergeUnknownRowCount() {
        TableStats stats1 = new TableStats(-1L, new HashMap());
        TableStats stats2 = new TableStats(32L, new HashMap());
        Assert.assertEquals((Object)new TableStats(-1L, new HashMap()), (Object)stats1.merge(stats2));
        stats1 = new TableStats(-1L, new HashMap());
        stats2 = new TableStats(-1L, new HashMap());
        Assert.assertEquals((Object)new TableStats(-1L, new HashMap()), (Object)stats1.merge(stats2));
        stats1 = new TableStats(-3L, new HashMap());
        stats2 = new TableStats(-2L, new HashMap());
        Assert.assertEquals((Object)new TableStats(-1L, new HashMap()), (Object)stats1.merge(stats2));
    }

    @Test
    public void testMergeColumnStatsUnknown() {
        ColumnStats columnStats0 = new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Number)15, (Number)2);
        ColumnStats columnStats1 = new ColumnStats(Long.valueOf(4L), null, Double.valueOf(2.0), Integer.valueOf(3), (Number)15, (Number)2);
        ColumnStats columnStats2 = new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), null, (Number)15, (Number)2);
        ColumnStats columnStats3 = new ColumnStats(null, Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Number)15, (Number)2);
        ColumnStats columnStats4 = new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), null, (Number)2);
        ColumnStats columnStats5 = new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Number)15, null);
        ColumnStats columnStats6 = new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), null, Integer.valueOf(3), (Number)15, (Number)2);
        Assert.assertEquals((Object)new ColumnStats(Long.valueOf(8L), null, Double.valueOf(2.0), Integer.valueOf(3), (Number)15, (Number)2), (Object)columnStats0.merge(columnStats1));
        Assert.assertEquals((Object)new ColumnStats(Long.valueOf(8L), Long.valueOf(10L), Double.valueOf(2.0), null, (Number)15, (Number)2), (Object)columnStats0.merge(columnStats2));
        Assert.assertEquals((Object)new ColumnStats(null, Long.valueOf(10L), Double.valueOf(2.0), Integer.valueOf(3), (Number)15, (Number)2), (Object)columnStats0.merge(columnStats3));
        Assert.assertEquals((Object)new ColumnStats(Long.valueOf(8L), Long.valueOf(10L), Double.valueOf(2.0), Integer.valueOf(3), null, (Number)2), (Object)columnStats0.merge(columnStats4));
        Assert.assertEquals((Object)new ColumnStats(Long.valueOf(8L), Long.valueOf(10L), Double.valueOf(2.0), Integer.valueOf(3), (Number)15, null), (Object)columnStats0.merge(columnStats5));
        Assert.assertEquals((Object)new ColumnStats(Long.valueOf(8L), Long.valueOf(10L), null, Integer.valueOf(3), (Number)15, (Number)2), (Object)columnStats0.merge(columnStats6));
        Assert.assertEquals((Object)new ColumnStats(Long.valueOf(8L), Long.valueOf(10L), null, Integer.valueOf(3), (Number)15, (Number)2), (Object)columnStats6.merge(columnStats6));
    }
}

