/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.math.BigDecimal;
import java.math.BigInteger;
import junit.framework.TestCase;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.ClassInstance;
import org.apache.flink.table.descriptors.FunctionDescriptor;
import org.apache.flink.table.functions.FunctionService;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.junit.Assert;
import org.junit.Test;

public class FunctionServiceTest {
    @Test(expected=ValidationException.class)
    public void testWrongArgsFunctionCreation() {
        FunctionDescriptor descriptor = new FunctionDescriptor().fromClass(new ClassInstance().of(NoArgClass.class.getName()).parameterString("12"));
        FunctionService.createFunction((FunctionDescriptor)descriptor);
    }

    @Test(expected=ValidationException.class)
    public void testPrivateFunctionCreation() {
        FunctionDescriptor descriptor = new FunctionDescriptor().fromClass(new ClassInstance().of(PrivateClass.class.getName()));
        FunctionService.createFunction((FunctionDescriptor)descriptor);
    }

    @Test(expected=ValidationException.class)
    public void testInvalidClassFunctionCreation() {
        FunctionDescriptor descriptor = new FunctionDescriptor().fromClass(new ClassInstance().of("this.class.does.not.exist"));
        FunctionService.createFunction((FunctionDescriptor)descriptor);
    }

    @Test(expected=ValidationException.class)
    public void testNotFunctionClassFunctionCreation() {
        FunctionDescriptor descriptor = new FunctionDescriptor().fromClass(new ClassInstance().of(String.class.getName()).parameterString("hello"));
        FunctionService.createFunction((FunctionDescriptor)descriptor);
    }

    @Test(expected=ValidationException.class)
    public void testErrorConstructorClass() {
        FunctionDescriptor descriptor = new FunctionDescriptor().fromClass(new ClassInstance().of(ErrorConstructorClass.class.getName()).parameterString("arg"));
        FunctionService.createFunction((FunctionDescriptor)descriptor);
    }

    @Test
    public void testNoArgFunctionCreation() {
        FunctionDescriptor descriptor = new FunctionDescriptor().fromClass(new ClassInstance().of(NoArgClass.class.getName()));
        TestCase.assertEquals(NoArgClass.class, FunctionService.createFunction((FunctionDescriptor)descriptor).getClass());
    }

    @Test
    public void testOneArgFunctionCreation() {
        FunctionDescriptor descriptor = new FunctionDescriptor().fromClass(new ClassInstance().of(OneArgClass.class.getName()).parameterString("false"));
        UserDefinedFunction actualFunction = FunctionService.createFunction((FunctionDescriptor)descriptor);
        TestCase.assertEquals(OneArgClass.class, actualFunction.getClass());
        Assert.assertFalse((boolean)((OneArgClass)actualFunction).field);
    }

    @Test
    public void testMultiArgFunctionCreation() {
        FunctionDescriptor descriptor = new FunctionDescriptor().fromClass(new ClassInstance().of(MultiArgClass.class.getName()).parameter(new BigDecimal("12.0003")).parameter(new ClassInstance().of(BigInteger.class.getName()).parameter("111111111111111111111111111111111")));
        UserDefinedFunction actualFunction = FunctionService.createFunction((FunctionDescriptor)descriptor);
        TestCase.assertEquals(MultiArgClass.class, actualFunction.getClass());
        TestCase.assertEquals((Object)new BigDecimal("12.0003"), (Object)((MultiArgClass)actualFunction).field1);
        TestCase.assertEquals((Object)new BigInteger("111111111111111111111111111111111"), (Object)((MultiArgClass)actualFunction).field2);
    }

    public static class ErrorConstructorClass
    extends ScalarFunction {
        public ErrorConstructorClass(String arg) {
            throw new RuntimeException(arg);
        }
    }

    public static class PrivateClass
    extends ScalarFunction {
        private PrivateClass() {
        }
    }

    public static class MultiArgClass
    extends ScalarFunction {
        public final BigDecimal field1;
        public final BigInteger field2;

        public MultiArgClass(BigDecimal field1, BigInteger field2) {
            this.field1 = field1;
            this.field2 = field2;
        }
    }

    public static class OneArgClass
    extends ScalarFunction {
        public Boolean field;

        public OneArgClass(Boolean field) {
            this.field = field;
        }
    }

    public static class NoArgClass
    extends ScalarFunction {
    }
}

