/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ExpressionTest {
    private static final ScalarFunction DUMMY_FUNCTION = new ScalarFunction(){};
    private static final Expression TREE_WITH_NULL = ExpressionTest.createExpressionTree(null);
    private static final Expression TREE_WITH_VALUE = ExpressionTest.createExpressionTree(12);
    private static final Expression TREE_WITH_SAME_VALUE = ExpressionTest.createExpressionTree(12);
    private static final String TREE_WITH_NULL_STRING = "and(true, equals(field, dummy(null)))";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testExpressionString() {
        Assert.assertEquals((Object)TREE_WITH_NULL_STRING, (Object)TREE_WITH_NULL.toString());
    }

    @Test
    public void testExpressionEquality() {
        Assert.assertEquals((Object)TREE_WITH_VALUE, (Object)TREE_WITH_SAME_VALUE);
    }

    @Test
    public void testArrayValueLiteralEquality() {
        Assert.assertEquals((Object)new ValueLiteralExpression((Object)new Integer[][]{null, null, {1, 2, 3}}), (Object)new ValueLiteralExpression((Object)new Integer[][]{null, null, {1, 2, 3}}));
        Assert.assertEquals((Object)new ValueLiteralExpression((Object)new String[][]{null, null, {"1", "2", "3", "Dog's"}}, (DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())).notNull()), (Object)new ValueLiteralExpression((Object)new String[][]{null, null, {"1", "2", "3", "Dog's"}}, (DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())).notNull()));
        Assert.assertEquals((Object)new ValueLiteralExpression((Object)"abc".getBytes(StandardCharsets.UTF_8)), (Object)new ValueLiteralExpression((Object)"abc".getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testExpressionInequality() {
        Assert.assertNotEquals((Object)TREE_WITH_NULL, (Object)TREE_WITH_VALUE);
    }

    @Test
    public void testValueLiteralString() {
        Assert.assertEquals((Object)"[null, null, [1, 2, 3]]", (Object)new ValueLiteralExpression((Object)new Integer[][]{null, null, {1, 2, 3}}).toString());
        Assert.assertEquals((Object)"[null, null, ['1', '2', '3', 'Dog''s']]", (Object)new ValueLiteralExpression((Object)new String[][]{null, null, {"1", "2", "3", "Dog's"}}, (DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())).notNull()).toString());
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        map.put("key1", 1);
        map.put("key2", 2);
        map.put("key3", 3);
        Assert.assertEquals((Object)"{key1=1, key2=2, key3=3}", (Object)new ValueLiteralExpression(map, (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()).notNull()).toString());
        Assert.assertEquals((Object)"{key1=1, key2=2, key3=3}", (Object)new ValueLiteralExpression(map, (DataType)DataTypes.MULTISET((DataType)DataTypes.STRING()).notNull()).toString());
    }

    @Test
    public void testInvalidValueLiteral() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("does not support a value literal of class 'java.lang.Integer'");
        new ValueLiteralExpression((Object)12, (DataType)DataTypes.TINYINT().notNull());
    }

    @Test
    public void testInvalidValueLiteralExtraction() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Cannot derive a data type");
        new ValueLiteralExpression((Object)this);
    }

    @Test
    public void testBigDecimalValueLiteralExtraction() {
        float f = 2.4444444f;
        Assert.assertEquals((float)2.4444444f, (float)new ValueLiteralExpression((Object)Float.valueOf(2.4444444f)).getValueAs(BigDecimal.class).map(BigDecimal::floatValue).orElseThrow(AssertionError::new).floatValue(), (float)0.0f);
    }

    @Test
    public void testLocalDateTimeValueLiteralExtraction() {
        Timestamp sqlTimestamp = Timestamp.valueOf("2006-11-03 00:00:00.123456789");
        LocalDateTime localDateTime = LocalDateTime.of(2006, 11, 3, 0, 0, 0, 123456789);
        Assert.assertEquals((Object)localDateTime, new ValueLiteralExpression((Object)sqlTimestamp).getValueAs(LocalDateTime.class).orElseThrow(AssertionError::new));
    }

    @Test
    public void testLocalTimeValueLiteralExtraction() {
        LocalTime localTime = LocalTime.of(12, 12, 12, 123456789);
        long nanos = localTime.toNanoOfDay();
        int millis = localTime.get(ChronoField.MILLI_OF_DAY);
        Time sqlTime = Time.valueOf("12:12:12");
        Assert.assertEquals((Object)localTime.withNano(0), new ValueLiteralExpression((Object)sqlTime).getValueAs(LocalTime.class).orElseThrow(AssertionError::new));
        Assert.assertEquals((Object)localTime, new ValueLiteralExpression((Object)nanos).getValueAs(LocalTime.class).orElseThrow(AssertionError::new));
        Assert.assertEquals((Object)localTime.minusNanos(456789L), new ValueLiteralExpression((Object)millis).getValueAs(LocalTime.class).orElseThrow(AssertionError::new));
    }

    @Test
    public void testLocalDateValueLiteralExtraction() {
        LocalDate localDate = LocalDate.of(2012, 12, 12);
        int daysSinceEpoch = (int)localDate.toEpochDay();
        Date sqlDate = Date.valueOf("2012-12-12");
        Assert.assertEquals((Object)localDate, new ValueLiteralExpression((Object)sqlDate).getValueAs(LocalDate.class).orElseThrow(AssertionError::new));
        Assert.assertEquals((Object)localDate, new ValueLiteralExpression((Object)daysSinceEpoch).getValueAs(LocalDate.class).orElseThrow(AssertionError::new));
    }

    @Test
    public void testInstantValueLiteralExtraction() {
        Instant instant = Instant.ofEpochMilli(100L);
        long millis = instant.toEpochMilli();
        int seconds = (int)instant.toEpochMilli() / 1000;
        Assert.assertEquals((Object)instant, new ValueLiteralExpression((Object)millis).getValueAs(Instant.class).orElseThrow(AssertionError::new));
        Assert.assertEquals((Object)instant.minusMillis(100L), new ValueLiteralExpression((Object)seconds).getValueAs(Instant.class).orElseThrow(AssertionError::new));
    }

    @Test
    public void testOffsetDateTimeValueLiteralExtraction() {
        OffsetDateTime offsetDateTime = OffsetDateTime.of(LocalDateTime.parse("2012-12-12T12:12:12"), ZoneOffset.ofHours(1));
        ZonedDateTime zonedDateTime = ZonedDateTime.of(LocalDateTime.parse("2012-12-12T12:12:12"), ZoneId.of("Europe/Berlin"));
        Assert.assertEquals((Object)offsetDateTime, new ValueLiteralExpression((Object)zonedDateTime).getValueAs(OffsetDateTime.class).orElseThrow(AssertionError::new));
    }

    @Test
    public void testSymbolValueLiteralExtraction() {
        TimeIntervalUnit intervalUnit = TimeIntervalUnit.DAY_TO_MINUTE;
        Assert.assertEquals((Object)intervalUnit, new ValueLiteralExpression((Object)intervalUnit).getValueAs(TimeIntervalUnit.class).orElseThrow(AssertionError::new));
    }

    @Test
    public void testPeriodValueLiteralExtraction() {
        Integer periodInInt = 10;
        Period expected = Period.ofMonths(10);
        Assert.assertEquals((Object)expected, new ValueLiteralExpression((Object)periodInInt).getValueAs(Period.class).orElseThrow(AssertionError::new));
    }

    private static Expression createExpressionTree(Integer nestedValue) {
        ValueLiteralExpression nestedLiteral = nestedValue != null ? new ValueLiteralExpression((Object)nestedValue, (DataType)DataTypes.INT().notNull()) : new ValueLiteralExpression(null, DataTypes.INT());
        return new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.AND, Arrays.asList(new ValueLiteralExpression((Object)true), new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(new FieldReferenceExpression("field", DataTypes.INT(), 0, 0), new CallExpression((FunctionDefinition)new ScalarFunctionDefinition("dummy", DUMMY_FUNCTION), Collections.singletonList(nestedLiteral), DataTypes.INT())), DataTypes.BOOLEAN())), DataTypes.BOOLEAN());
    }
}

