/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.FunctionRequirement;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.util.Preconditions;

@Internal
public final class ScalarFunctionDefinition
implements FunctionDefinition {
    private final String name;
    private final ScalarFunction scalarFunction;

    public ScalarFunctionDefinition(String name, ScalarFunction scalarFunction) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.scalarFunction = (ScalarFunction)Preconditions.checkNotNull((Object)scalarFunction);
    }

    public String getName() {
        return this.name;
    }

    public ScalarFunction getScalarFunction() {
        return this.scalarFunction;
    }

    @Override
    public FunctionKind getKind() {
        return FunctionKind.SCALAR;
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory factory) {
        throw new TableException("Functions implemented for the old type system are not supported.");
    }

    @Override
    public Set<FunctionRequirement> getRequirements() {
        return this.scalarFunction.getRequirements();
    }

    @Override
    public boolean isDeterministic() {
        return this.scalarFunction.isDeterministic();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScalarFunctionDefinition that = (ScalarFunctionDefinition)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }
}

