/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.Preconditions;

@Internal
public final class BuiltInFunctionDefinition
implements SpecializedFunction {
    private final String name;
    private final FunctionKind kind;
    private final TypeInference typeInference;
    private final boolean isDeterministic;
    @Nullable
    private String runtimeClass;

    private BuiltInFunctionDefinition(String name, FunctionKind kind, TypeInference typeInference, boolean isDeterministic, String runtimeClass) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"Name must not be null.");
        this.kind = (FunctionKind)((Object)Preconditions.checkNotNull((Object)((Object)kind), (String)"Kind must not be null."));
        this.typeInference = (TypeInference)Preconditions.checkNotNull((Object)typeInference, (String)"Type inference must not be null.");
        this.isDeterministic = isDeterministic;
        this.runtimeClass = runtimeClass;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getRuntimeClass() {
        return Optional.ofNullable(this.runtimeClass);
    }

    @Override
    public UserDefinedFunction specialize(SpecializedFunction.SpecializedContext context) {
        if (this.runtimeClass == null) {
            throw new TableException(String.format("Could not find a runtime implementation for built-in function '%s'. The planner should have provided an implementation.", this.name));
        }
        try {
            Class<?> udfClass = Class.forName(this.runtimeClass, true, context.getBuiltInClassLoader());
            Constructor<?> udfConstructor = udfClass.getConstructor(SpecializedFunction.SpecializedContext.class);
            UserDefinedFunction udf = (UserDefinedFunction)udfConstructor.newInstance(context);
            if (udf instanceof SpecializedFunction) {
                return ((SpecializedFunction)((Object)udf)).specialize(context);
            }
            return udf;
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not instantiate a runtime implementation for built-in function '%s'.", this.name), e);
        }
    }

    @Override
    public FunctionKind getKind() {
        return this.kind;
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return this.typeInference;
    }

    @Override
    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public String toString() {
        return this.name;
    }

    public static final class Builder {
        private String name;
        private FunctionKind kind;
        private TypeInference.Builder typeInferenceBuilder = TypeInference.newBuilder();
        private boolean isDeterministic = true;
        private String runtimeClass;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder kind(FunctionKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder namedArguments(String ... argumentNames) {
            this.typeInferenceBuilder.namedArguments(Arrays.asList(argumentNames));
            return this;
        }

        public Builder typedArguments(DataType ... argumentTypes) {
            this.typeInferenceBuilder.typedArguments(Arrays.asList(argumentTypes));
            return this;
        }

        public Builder inputTypeStrategy(InputTypeStrategy inputTypeStrategy) {
            this.typeInferenceBuilder.inputTypeStrategy(inputTypeStrategy);
            return this;
        }

        public Builder outputTypeStrategy(TypeStrategy outputTypeStrategy) {
            this.typeInferenceBuilder.outputTypeStrategy(outputTypeStrategy);
            return this;
        }

        public Builder notDeterministic() {
            this.isDeterministic = false;
            return this;
        }

        public Builder runtimeClass(String runtimeClass) {
            this.runtimeClass = runtimeClass;
            return this;
        }

        public BuiltInFunctionDefinition build() {
            return new BuiltInFunctionDefinition(this.name, this.kind, this.typeInferenceBuilder.build(), this.isDeterministic, this.runtimeClass);
        }
    }
}

