/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeStrategy;

@Internal
public final class MappingTypeStrategy
implements TypeStrategy {
    private final Map<InputTypeStrategy, TypeStrategy> mappings;

    public MappingTypeStrategy(Map<InputTypeStrategy, TypeStrategy> mappings) {
        this.mappings = mappings;
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        List actualTypes = callContext.getArgumentDataTypes().stream().map(DataType::getLogicalType).collect(Collectors.toList());
        for (Map.Entry<InputTypeStrategy, TypeStrategy> mapping : this.mappings.entrySet()) {
            List inferredTypes;
            Optional<List<DataType>> inferredDataTypes;
            InputTypeStrategy inputStrategy = mapping.getKey();
            TypeStrategy strategy = mapping.getValue();
            if (!inputStrategy.getArgumentCount().isValidCount(actualTypes.size()) || !(inferredDataTypes = inputStrategy.inferInputTypes(callContext, false)).isPresent() || !actualTypes.equals(inferredTypes = inferredDataTypes.get().stream().map(DataType::getLogicalType).collect(Collectors.toList()))) continue;
            return strategy.inferType(callContext);
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingTypeStrategy that = (MappingTypeStrategy)o;
        return this.mappings.equals(that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.mappings);
    }
}

