/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class KeyValueDataType
extends DataType {
    private final DataType keyDataType;
    private final DataType valueDataType;

    public KeyValueDataType(LogicalType logicalType, @Nullable Class<?> conversionClass, DataType keyDataType, DataType valueDataType) {
        super(logicalType, conversionClass);
        this.keyDataType = (DataType)Preconditions.checkNotNull((Object)keyDataType, (String)"Key data type must not be null.");
        this.valueDataType = (DataType)Preconditions.checkNotNull((Object)valueDataType, (String)"Value data type must not be null.");
    }

    public KeyValueDataType(LogicalType logicalType, DataType keyDataType, DataType valueDataType) {
        this(logicalType, null, keyDataType, valueDataType);
    }

    public DataType getKeyDataType() {
        return this.keyDataType;
    }

    public DataType getValueDataType() {
        return this.valueDataType;
    }

    @Override
    public DataType notNull() {
        return new KeyValueDataType(this.logicalType.copy(false), this.conversionClass, this.keyDataType, this.valueDataType);
    }

    @Override
    public DataType nullable() {
        return new KeyValueDataType(this.logicalType.copy(true), this.conversionClass, this.keyDataType, this.valueDataType);
    }

    @Override
    public DataType bridgedTo(Class<?> newConversionClass) {
        return new KeyValueDataType(this.logicalType, (Class)Preconditions.checkNotNull(newConversionClass, (String)"New conversion class must not be null."), this.keyDataType, this.valueDataType);
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyValueDataType that = (KeyValueDataType)o;
        return this.keyDataType.equals(that.keyDataType) && this.valueDataType.equals(that.valueDataType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keyDataType, this.valueDataType);
    }
}

