/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public final class FunctionIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final ObjectIdentifier objectIdentifier;
    @Nullable
    private final String functionName;

    public static FunctionIdentifier of(ObjectIdentifier oi) {
        return new FunctionIdentifier(oi);
    }

    public static FunctionIdentifier of(String functionName) {
        return new FunctionIdentifier(functionName);
    }

    private FunctionIdentifier(ObjectIdentifier objectIdentifier) {
        Preconditions.checkNotNull((Object)objectIdentifier, (String)"Object identifier cannot be null");
        this.objectIdentifier = objectIdentifier;
        this.functionName = null;
    }

    private FunctionIdentifier(String functionName) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)functionName) ? 1 : 0) != 0, (Object)"function name cannot be null or empty string");
        this.functionName = functionName;
        this.objectIdentifier = null;
    }

    public static String normalizeName(String name) {
        return name.toLowerCase();
    }

    public static ObjectIdentifier normalizeObjectIdentifier(ObjectIdentifier oi) {
        return ObjectIdentifier.of(oi.getCatalogName(), oi.getDatabaseName(), FunctionIdentifier.normalizeName(oi.getObjectName()));
    }

    public Optional<ObjectIdentifier> getIdentifier() {
        return Optional.ofNullable(this.objectIdentifier);
    }

    public Optional<String> getSimpleName() {
        return Optional.ofNullable(this.functionName);
    }

    public List<String> getNames() {
        if (this.objectIdentifier != null) {
            return Arrays.asList(this.objectIdentifier.getCatalogName(), this.objectIdentifier.getDatabaseName(), this.objectIdentifier.getObjectName());
        }
        if (this.functionName != null) {
            return Collections.singletonList(this.functionName);
        }
        throw new IllegalStateException("functionName and objectIdentifier are both null which should never happen.");
    }

    public String asSummaryString() {
        if (this.objectIdentifier != null) {
            return String.join((CharSequence)".", this.objectIdentifier.getCatalogName(), this.objectIdentifier.getDatabaseName(), this.objectIdentifier.getObjectName());
        }
        return this.functionName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionIdentifier that = (FunctionIdentifier)o;
        return Objects.equals(this.objectIdentifier, that.objectIdentifier) && Objects.equals(this.functionName, that.functionName);
    }

    public int hashCode() {
        return Objects.hash(this.objectIdentifier, this.functionName);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

