/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class SetQueryOperation
implements QueryOperation {
    private final QueryOperation leftOperation;
    private final QueryOperation rightOperation;
    private final SetQueryOperationType type;
    private final boolean all;
    private final ResolvedSchema resolvedSchema;

    public SetQueryOperation(QueryOperation leftOperation, QueryOperation rightOperation, SetQueryOperationType type, boolean all, ResolvedSchema resolvedSchema) {
        this.leftOperation = leftOperation;
        this.rightOperation = rightOperation;
        this.type = type;
        this.all = all;
        this.resolvedSchema = resolvedSchema;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("all", this.all);
        return OperationUtils.formatWithChildren(this.typeToString(), args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public String asSerializableString() {
        return String.format("SELECT %s FROM (%s\n) %s (%s\n)", OperationUtils.formatSelectColumns(this.resolvedSchema), OperationUtils.indent(this.leftOperation.asSerializableString()), this.asSerializableType(), OperationUtils.indent(this.rightOperation.asSerializableString()));
    }

    private String asSerializableType() {
        if (this.all) {
            return this.type.toString() + " ALL";
        }
        return this.type.toString();
    }

    private String typeToString() {
        switch (this.type) {
            case INTERSECT: {
                return "Intersect";
            }
            case MINUS: {
                return "Minus";
            }
            case UNION: {
                return "Union";
            }
        }
        throw new IllegalStateException("Unknown set operation type: " + this.type);
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Arrays.asList(this.leftOperation, this.rightOperation);
    }

    public SetQueryOperationType getType() {
        return this.type;
    }

    public boolean isAll() {
        return this.all;
    }

    @Internal
    public static enum SetQueryOperationType {
        INTERSECT,
        MINUS,
        UNION;

    }
}

