/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.utils.EncodingUtils;

@Internal
public class SourceQueryOperation
implements QueryOperation {
    private final ContextResolvedTable contextResolvedTable;
    @Nullable
    private final Map<String, String> dynamicOptions;

    public SourceQueryOperation(ContextResolvedTable contextResolvedTable) {
        this(contextResolvedTable, null);
    }

    public SourceQueryOperation(ContextResolvedTable contextResolvedTable, @Nullable Map<String, String> dynamicOptions) {
        this.contextResolvedTable = contextResolvedTable;
        this.dynamicOptions = dynamicOptions;
    }

    public ContextResolvedTable getContextResolvedTable() {
        return this.contextResolvedTable;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.contextResolvedTable.getResolvedSchema();
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("identifier", this.getContextResolvedTable().getIdentifier().asSummaryString());
        args.put("fields", this.getResolvedSchema().getColumnNames());
        if (this.dynamicOptions != null) {
            args.put("options", this.dynamicOptions);
        }
        return OperationUtils.formatWithChildren("CatalogTable", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public String asSerializableString() {
        String s = String.format("SELECT %s FROM %s", this.getResolvedSchema().getColumnNames().stream().map(EncodingUtils::escapeIdentifier).collect(Collectors.joining(", ")), this.getContextResolvedTable().getIdentifier().asSerializableString());
        if (this.dynamicOptions != null && !this.dynamicOptions.isEmpty()) {
            throw new TableException("Dynamic source options are not SQL serializable yet.");
        }
        return s;
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Nullable
    public Map<String, String> getDynamicOptions() {
        return this.dynamicOptions;
    }
}

