/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.utils.EncodingUtils;

@Internal
public class ShowCreateUtil {
    private ShowCreateUtil() {
    }

    public static String buildShowCreateTableRow(ResolvedCatalogBaseTable<?> table, ObjectIdentifier tableIdentifier, boolean isTemporary) {
        if (table.getTableKind() == CatalogBaseTable.TableKind.VIEW) {
            throw new TableException(String.format("SHOW CREATE TABLE is only supported for tables, but %s is a view. Please use SHOW CREATE VIEW instead.", tableIdentifier.asSerializableString()));
        }
        String printIndent = "  ";
        StringBuilder sb = new StringBuilder().append(ShowCreateUtil.buildCreateFormattedPrefix("TABLE", isTemporary, tableIdentifier));
        sb.append(ShowCreateUtil.extractFormattedColumns(table, "  "));
        ShowCreateUtil.extractFormattedWatermarkSpecs(table, "  ").ifPresent(watermarkSpecs -> sb.append(",\n").append((String)watermarkSpecs));
        ShowCreateUtil.extractFormattedPrimaryKey(table, "  ").ifPresent(pk -> sb.append(",\n").append((String)pk));
        sb.append("\n) ");
        ShowCreateUtil.extractFormattedComment(table).ifPresent(c -> sb.append(String.format("COMMENT '%s'%s", c, System.lineSeparator())));
        ShowCreateUtil.extractFormattedPartitionedInfo((ResolvedCatalogTable)table).ifPresent(partitionedInfoFormatted -> sb.append("PARTITIONED BY (").append((String)partitionedInfoFormatted).append(")\n"));
        ShowCreateUtil.extractFormattedOptions(table, "  ").ifPresent(v -> sb.append("WITH (\n").append((String)v).append("\n)\n"));
        return sb.toString();
    }

    public static String buildShowCreateViewRow(ResolvedCatalogBaseTable<?> view, ObjectIdentifier viewIdentifier, boolean isTemporary) {
        if (view.getTableKind() != CatalogBaseTable.TableKind.VIEW) {
            throw new TableException(String.format("SHOW CREATE VIEW is only supported for views, but %s is a table. Please use SHOW CREATE TABLE instead.", viewIdentifier.asSerializableString()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (view.getOrigin() instanceof QueryOperationCatalogView) {
            throw new TableException("SHOW CREATE VIEW is not supported for views registered by Table API.");
        }
        stringBuilder.append(String.format("CREATE %sVIEW %s%s as%s%s", isTemporary ? "TEMPORARY " : "", viewIdentifier.asSerializableString(), String.format("(%s)", ShowCreateUtil.extractFormattedColumnNames(view)), System.lineSeparator(), ((CatalogView)view.getOrigin()).getExpandedQuery()));
        ShowCreateUtil.extractFormattedComment(view).ifPresent(c -> stringBuilder.append(String.format(" COMMENT '%s'%s", c, System.lineSeparator())));
        return stringBuilder.toString();
    }

    static String buildCreateFormattedPrefix(String tableType, boolean isTemporary, ObjectIdentifier identifier) {
        return String.format("CREATE %s%s %s (%s", isTemporary ? "TEMPORARY " : "", tableType, identifier.asSerializableString(), System.lineSeparator());
    }

    static Optional<String> extractFormattedPrimaryKey(ResolvedCatalogBaseTable<?> table, String printIndent) {
        Optional primaryKey = table.getResolvedSchema().getPrimaryKey();
        return primaryKey.map(uniqueConstraint -> String.format("%s%s", printIndent, uniqueConstraint));
    }

    static String getColumnString(Column column) {
        StringBuilder sb = new StringBuilder();
        sb.append(EncodingUtils.escapeIdentifier((String)column.getName()));
        sb.append(" ");
        if (column instanceof Column.ComputedColumn) {
            sb.append((String)column.explainExtras().orElseThrow(() -> new TableException(String.format("Column expression can not be null for computed column '%s'", column.getName()))));
        } else {
            sb.append(column.getDataType().getLogicalType().asSerializableString());
            column.explainExtras().ifPresent(e -> {
                sb.append(" ");
                sb.append((String)e);
            });
        }
        column.getComment().ifPresent(comment -> {
            if (StringUtils.isNotEmpty((CharSequence)comment)) {
                sb.append(" ");
                sb.append(String.format("COMMENT '%s'", EncodingUtils.escapeSingleQuotes((String)comment)));
            }
        });
        return sb.toString();
    }

    static String extractFormattedColumns(ResolvedCatalogBaseTable<?> table, String printIndent) {
        return table.getResolvedSchema().getColumns().stream().map(column -> String.format("%s%s", printIndent, ShowCreateUtil.getColumnString(column))).collect(Collectors.joining(",\n"));
    }

    static Optional<String> extractFormattedWatermarkSpecs(ResolvedCatalogBaseTable<?> table, String printIndent) {
        if (table.getResolvedSchema().getWatermarkSpecs().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(table.getResolvedSchema().getWatermarkSpecs().stream().map(watermarkSpec -> String.format("%sWATERMARK FOR %s AS %s", printIndent, EncodingUtils.escapeIdentifier((String)watermarkSpec.getRowtimeAttribute()), watermarkSpec.getWatermarkExpression().asSerializableString())).collect(Collectors.joining("\n")));
    }

    static Optional<String> extractFormattedComment(ResolvedCatalogBaseTable<?> table) {
        String comment = table.getComment();
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            return Optional.of(EncodingUtils.escapeSingleQuotes((String)comment));
        }
        return Optional.empty();
    }

    static Optional<String> extractFormattedPartitionedInfo(ResolvedCatalogTable catalogTable) {
        if (!catalogTable.isPartitioned()) {
            return Optional.empty();
        }
        return Optional.of(catalogTable.getPartitionKeys().stream().map(EncodingUtils::escapeIdentifier).collect(Collectors.joining(", ")));
    }

    static Optional<String> extractFormattedOptions(ResolvedCatalogBaseTable<?> table, String printIndent) {
        if (Objects.isNull(table.getOptions()) || table.getOptions().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(table.getOptions().entrySet().stream().map(entry -> String.format("%s'%s' = '%s'", printIndent, EncodingUtils.escapeSingleQuotes((String)((String)entry.getKey())), EncodingUtils.escapeSingleQuotes((String)((String)entry.getValue())))).collect(Collectors.joining(",\n")));
    }

    static String extractFormattedColumnNames(ResolvedCatalogBaseTable<?> baseTable) {
        return baseTable.getResolvedSchema().getColumns().stream().map(Column::getName).map(EncodingUtils::escapeIdentifier).collect(Collectors.joining(", "));
    }
}

