/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.types.inference.utils.FunctionDefinitionMock;

public class ModuleMock
implements Module {
    public static final String DUMMY_FUNCTION_NAME = "dummy";
    public static final FunctionDefinition DUMMY_FUNCTION_DEFINITION = new FunctionDefinitionMock(FunctionKind.SCALAR, null);
    public static final String INTERNAL_FUNCTION_NAME = "internal";
    public static final FunctionDefinition INTERNAL_FUNCTION_DEFINITION = new FunctionDefinitionMock(FunctionKind.OTHER, null);
    private static final Set<String> BUILT_IN_FUNCTIONS = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("dummy")));
    private static final Set<String> BUILT_IN_FUNCTIONS_WITH_INTERNAL = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("dummy", "internal")));
    private final String type;

    public ModuleMock(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Set<String> listFunctions() {
        return this.listFunctions(false);
    }

    public Set<String> listFunctions(boolean includeHiddenFunctions) {
        if (includeHiddenFunctions) {
            return BUILT_IN_FUNCTIONS_WITH_INTERNAL;
        }
        return BUILT_IN_FUNCTIONS;
    }

    public Optional<FunctionDefinition> getFunctionDefinition(String name) {
        switch (name) {
            case "dummy": {
                return Optional.of(DUMMY_FUNCTION_DEFINITION);
            }
            case "internal": {
                return Optional.of(INTERNAL_FUNCTION_DEFINITION);
            }
        }
        return Optional.empty();
    }
}

