/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SourceQueryOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.table.utils.FunctionLookupMock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ExpressionResolverTest {
    ExpressionResolverTest() {
    }

    static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestSpec.test("Columns range").inputSchemas(TableSchema.builder().field("f0", DataTypes.BIGINT()).field("f1", DataTypes.STRING()).field("f2", DataTypes.SMALLINT()).build()).select(new Expression[]{Expressions.withColumns((Object)Expressions.range((String)"f1", (String)"f2"), (Object[])new Object[0]), Expressions.withColumns((Object)Expressions.range((int)1, (int)2), (Object[])new Object[0])}).equalTo(new ResolvedExpression[]{new FieldReferenceExpression("f1", DataTypes.STRING(), 0, 1), new FieldReferenceExpression("f2", DataTypes.SMALLINT(), 0, 2), new FieldReferenceExpression("f0", DataTypes.BIGINT(), 0, 0), new FieldReferenceExpression("f1", DataTypes.STRING(), 0, 1)})}), Arguments.of((Object[])new Object[]{TestSpec.test("Flatten call").inputSchemas(TableSchema.builder().field("f0", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"n0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"n1", (DataType)DataTypes.STRING())})).build()).select((Expression)Expressions.$((String)"f0").flatten()).equalTo(new ResolvedExpression[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.GET, Arrays.asList(new FieldReferenceExpression("f0", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"n0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"n1", (DataType)DataTypes.STRING())}), 0, 0), new ValueLiteralExpression((Object)"n0")), (DataType)DataTypes.BIGINT()), CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.GET, Arrays.asList(new FieldReferenceExpression("f0", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"n0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"n1", (DataType)DataTypes.STRING())}), 0, 0), new ValueLiteralExpression((Object)"n1")), (DataType)DataTypes.STRING())})}), Arguments.of((Object[])new Object[]{TestSpec.test("Builtin function calls").inputSchemas(TableSchema.builder().field("f0", DataTypes.INT()).field("f1", DataTypes.DOUBLE()).build()).select((Expression)Expressions.$((String)"f0").isEqual((Object)Expressions.$((String)"f1"))).equalTo(new ResolvedExpression[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(new FieldReferenceExpression("f0", DataTypes.INT(), 0, 0), new FieldReferenceExpression("f1", DataTypes.DOUBLE(), 0, 1)), (DataType)DataTypes.BOOLEAN())})}), Arguments.of((Object[])new Object[]{TestSpec.test("Lookup legacy scalar function call").inputSchemas(TableSchema.builder().field("f0", DataTypes.INT()).build()).lookupFunction("func", (FunctionDefinition)new ScalarFunctionDefinition("func", (ScalarFunction)new LegacyScalarFunc())).select(new Expression[]{Expressions.call((String)"func", (Object[])new Object[]{1, Expressions.$((String)"f0")})}).equalTo(new ResolvedExpression[]{CallExpression.permanent((FunctionIdentifier)FunctionIdentifier.of((String)"func"), (FunctionDefinition)new ScalarFunctionDefinition("func", (ScalarFunction)new LegacyScalarFunc()), Arrays.asList(ApiExpressionUtils.valueLiteral((Object)1), new FieldReferenceExpression("f0", DataTypes.INT(), 0, 0)), (DataType)((DataType)DataTypes.INT().bridgedTo(Integer.class)))})}), Arguments.of((Object[])new Object[]{TestSpec.test("Lookup system function call").inputSchemas(TableSchema.builder().field("f0", DataTypes.INT()).build()).lookupFunction("func", (FunctionDefinition)new ScalarFunc()).select(new Expression[]{Expressions.call((String)"func", (Object[])new Object[]{1, Expressions.$((String)"f0")})}).equalTo(new ResolvedExpression[]{CallExpression.permanent((FunctionIdentifier)FunctionIdentifier.of((String)"func"), (FunctionDefinition)new ScalarFunc(), Arrays.asList(ApiExpressionUtils.valueLiteral((Object)1), new FieldReferenceExpression("f0", DataTypes.INT(), 0, 0)), (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))})}), Arguments.of((Object[])new Object[]{TestSpec.test("Inline function call via a class").inputSchemas(TableSchema.builder().field("f0", DataTypes.INT()).build()).select(new Expression[]{Expressions.call(ScalarFunc.class, (Object[])new Object[]{1, Expressions.$((String)"f0")})}).equalTo(new ResolvedExpression[]{CallExpression.anonymous((FunctionDefinition)new ScalarFunc(), Arrays.asList(ApiExpressionUtils.valueLiteral((Object)1), new FieldReferenceExpression("f0", DataTypes.INT(), 0, 0)), (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))})}), Arguments.of((Object[])new Object[]{TestSpec.test("Lookup catalog function call").inputSchemas(TableSchema.builder().field("f0", DataTypes.INT()).build()).lookupFunction(ObjectIdentifier.of((String)"cat", (String)"db", (String)"func"), (FunctionDefinition)new ScalarFunc()).select(new Expression[]{Expressions.call((String)"cat.db.func", (Object[])new Object[]{1, Expressions.$((String)"f0")})}).equalTo(new ResolvedExpression[]{CallExpression.permanent((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"func")), (FunctionDefinition)new ScalarFunc(), Arrays.asList(ApiExpressionUtils.valueLiteral((Object)1), new FieldReferenceExpression("f0", DataTypes.INT(), 0, 0)), (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))})}), Arguments.of((Object[])new Object[]{TestSpec.test("Deeply nested user-defined inline calls").inputSchemas(TableSchema.builder().field("f0", DataTypes.INT()).build()).lookupFunction("func", (FunctionDefinition)new ScalarFunc()).select(new Expression[]{Expressions.call((String)"func", (Object[])new Object[]{Expressions.call((UserDefinedFunction)new ScalarFunc(), (Object[])new Object[]{Expressions.call((String)"func", (Object[])new Object[]{1, Expressions.$((String)"f0")})})})}).equalTo(new ResolvedExpression[]{CallExpression.permanent((FunctionIdentifier)FunctionIdentifier.of((String)"func"), (FunctionDefinition)new ScalarFunc(), Collections.singletonList(CallExpression.anonymous((FunctionDefinition)new ScalarFunc(), Collections.singletonList(CallExpression.permanent((FunctionIdentifier)FunctionIdentifier.of((String)"func"), (FunctionDefinition)new ScalarFunc(), Arrays.asList(ApiExpressionUtils.valueLiteral((Object)1), new FieldReferenceExpression("f0", DataTypes.INT(), 0, 0)), (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))})}), Arguments.of((Object[])new Object[]{TestSpec.test("Star expression as parameter of user-defined func").inputSchemas(TableSchema.builder().field("f0", DataTypes.INT()).field("f1", DataTypes.STRING()).build()).lookupFunction("func", (FunctionDefinition)new ScalarFunc()).select(new Expression[]{Expressions.call((String)"func", (Object[])new Object[]{Expressions.$((String)"*")})}).equalTo(new ResolvedExpression[]{CallExpression.permanent((FunctionIdentifier)FunctionIdentifier.of((String)"func"), (FunctionDefinition)new ScalarFunc(), Arrays.asList(new FieldReferenceExpression("f0", DataTypes.INT(), 0, 0), new FieldReferenceExpression("f1", DataTypes.STRING(), 0, 1)), (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))})}), Arguments.of((Object[])new Object[]{TestSpec.test("Test field reference with col()").inputSchemas(TableSchema.builder().field("i", DataTypes.INT()).build()).select(new Expression[]{Expressions.col((String)"i")}).equalTo(new ResolvedExpression[]{new FieldReferenceExpression("i", DataTypes.INT(), 0, 0)})}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void testResolvingExpressions(TestSpec testSpec) {
        List resolvedExpressions = testSpec.getResolver().resolve(Arrays.asList(testSpec.expressions));
        Assertions.assertThat((List)resolvedExpressions).isEqualTo((Object)testSpec.expectedExpressions);
    }

    private static class TestSpec {
        private final String description;
        private TableSchema[] schemas;
        private Expression[] expressions;
        private List<ResolvedExpression> expectedExpressions;
        private Map<FunctionIdentifier, FunctionDefinition> functions = new HashMap<FunctionIdentifier, FunctionDefinition>();

        private TestSpec(String description) {
            this.description = description;
        }

        public static TestSpec test(String description) {
            return new TestSpec(description);
        }

        public TestSpec inputSchemas(TableSchema ... schemas) {
            this.schemas = schemas;
            return this;
        }

        public TestSpec lookupFunction(String name, FunctionDefinition functionDefinition) {
            this.functions.put(FunctionIdentifier.of((String)name), functionDefinition);
            return this;
        }

        public TestSpec lookupFunction(ObjectIdentifier identifier, FunctionDefinition functionDefinition) {
            this.functions.put(FunctionIdentifier.of((ObjectIdentifier)identifier), functionDefinition);
            return this;
        }

        public TestSpec select(Expression ... expressions) {
            this.expressions = expressions;
            return this;
        }

        public TestSpec equalTo(ResolvedExpression ... resolvedExpressions) {
            this.expectedExpressions = Arrays.asList(resolvedExpressions);
            return this;
        }

        public ExpressionResolver getResolver() {
            return ExpressionResolver.resolverFor((TableConfig)TableConfig.getDefault(), (ClassLoader)Thread.currentThread().getContextClassLoader(), name -> Optional.empty(), (FunctionLookup)new FunctionLookupMock(this.functions), (DataTypeFactory)new DataTypeFactoryMock(), (sqlExpression, inputRowType, outputType) -> {
                throw new UnsupportedOperationException();
            }, (QueryOperation[])((QueryOperation[])Arrays.stream(this.schemas).map(schema -> new SourceQueryOperation(ContextResolvedTable.anonymous((ResolvedCatalogBaseTable)new ResolvedCatalogTable(CatalogTable.of((Schema)schema.toSchema(), null, Collections.emptyList(), Collections.emptyMap()), ResolvedSchema.physical((String[])schema.getFieldNames(), (DataType[])schema.getFieldDataTypes()))))).toArray(QueryOperation[]::new))).build();
        }

        public String toString() {
            return this.description;
        }
    }

    public static class LegacyScalarFunc
    extends ScalarFunction {
        public int eval(Object ... any) {
            return 0;
        }

        public TypeInformation<?> getResultType(Class<?>[] signature) {
            return Types.INT;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof ScalarFunc;
        }
    }

    @FunctionHint(input={@DataTypeHint(inputGroup=InputGroup.ANY)}, isVarArgs=true, output=@DataTypeHint(value="INTEGER NOT NULL", bridgedTo=int.class))
    public static class ScalarFunc
    extends ScalarFunction {
        public int eval(Object ... any) {
            return 0;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof ScalarFunc;
        }
    }
}

