/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.ZoneId;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableConfig;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TableConfigTest {
    private static final TableConfig CONFIG_BY_METHOD = TableConfig.getDefault();
    private static final TableConfig CONFIG_BY_CONFIGURATION = TableConfig.getDefault();
    private static final Configuration configuration = new Configuration();

    @Test
    void testSetAndGetSqlDialect() {
        configuration.setString("table.sql-dialect", "HIVE");
        CONFIG_BY_CONFIGURATION.addConfiguration(configuration);
        CONFIG_BY_METHOD.setSqlDialect(SqlDialect.HIVE);
        Assertions.assertThat((Comparable)CONFIG_BY_METHOD.getSqlDialect()).isEqualTo((Object)SqlDialect.HIVE);
        Assertions.assertThat((Comparable)CONFIG_BY_CONFIGURATION.getSqlDialect()).isEqualTo((Object)SqlDialect.HIVE);
    }

    @Test
    void testSetAndGetMaxGeneratedCodeLength() {
        configuration.setString("table.generated-code.max-length", "5000");
        CONFIG_BY_CONFIGURATION.addConfiguration(configuration);
        CONFIG_BY_METHOD.setMaxGeneratedCodeLength(Integer.valueOf(5000));
        Assertions.assertThat((Integer)CONFIG_BY_METHOD.getMaxGeneratedCodeLength()).isEqualTo((Object)5000);
        Assertions.assertThat((Integer)CONFIG_BY_CONFIGURATION.getMaxGeneratedCodeLength()).isEqualTo((Object)5000);
    }

    @Test
    void testSetAndGetLocalTimeZone() {
        configuration.setString("table.local-time-zone", "Asia/Shanghai");
        CONFIG_BY_CONFIGURATION.addConfiguration(configuration);
        CONFIG_BY_METHOD.setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        Assertions.assertThat((Object)CONFIG_BY_METHOD.getLocalTimeZone()).isEqualTo((Object)ZoneId.of("Asia/Shanghai"));
        Assertions.assertThat((Object)CONFIG_BY_CONFIGURATION.getLocalTimeZone()).isEqualTo((Object)ZoneId.of("Asia/Shanghai"));
        configuration.setString("table.local-time-zone", "GMT-08:00");
        CONFIG_BY_CONFIGURATION.addConfiguration(configuration);
        CONFIG_BY_METHOD.setLocalTimeZone(ZoneId.of("GMT-08:00"));
        Assertions.assertThat((Object)CONFIG_BY_METHOD.getLocalTimeZone()).isEqualTo((Object)ZoneId.of("GMT-08:00"));
        Assertions.assertThat((Object)CONFIG_BY_CONFIGURATION.getLocalTimeZone()).isEqualTo((Object)ZoneId.of("GMT-08:00"));
    }

    @Test
    public void testSetInvalidLocalTimeZone() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CONFIG_BY_METHOD.setLocalTimeZone(ZoneId.of("UTC-10:00"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("The supported Zone ID is either a full name such as 'America/Los_Angeles', or a custom timezone id such as 'GMT-08:00', but configured Zone ID is 'UTC-10:00'.");
    }

    @Test
    public void testInvalidGmtLocalTimeZone() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CONFIG_BY_METHOD.setLocalTimeZone(ZoneId.of("GMT-8:00"))).isInstanceOf(DateTimeException.class)).hasMessage("Invalid ID for offset-based ZoneId: GMT-8:00");
    }

    @Test
    void testGetInvalidLocalTimeZone() {
        configuration.setString("table.local-time-zone", "UTC+8");
        CONFIG_BY_CONFIGURATION.addConfiguration(configuration);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TableConfig)CONFIG_BY_CONFIGURATION).getLocalTimeZone()).isInstanceOf(IllegalArgumentException.class)).hasMessage("The supported Zone ID is either a full name such as 'America/Los_Angeles', or a custom timezone id such as 'GMT-08:00', but configured Zone ID is 'UTC+8'.");
    }

    @Test
    void testGetInvalidAbbreviationLocalTimeZone() {
        configuration.setString("table.local-time-zone", "PST");
        CONFIG_BY_CONFIGURATION.addConfiguration(configuration);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TableConfig)CONFIG_BY_CONFIGURATION).getLocalTimeZone()).isInstanceOf(IllegalArgumentException.class)).hasMessage("The supported Zone ID is either a full name such as 'America/Los_Angeles', or a custom timezone id such as 'GMT-08:00', but configured Zone ID is 'PST'.");
    }

    @Test
    void testSetAndGetIdleStateRetention() {
        configuration.setString("table.exec.state.ttl", "1 h");
        CONFIG_BY_CONFIGURATION.addConfiguration(configuration);
        CONFIG_BY_METHOD.setIdleStateRetention(Duration.ofHours(1L));
        Assertions.assertThat((Duration)CONFIG_BY_METHOD.getIdleStateRetention()).isEqualTo((Object)Duration.ofHours(1L));
        Assertions.assertThat((Duration)CONFIG_BY_CONFIGURATION.getIdleStateRetention()).isEqualTo((Object)Duration.ofHours(1L));
    }
}

