/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.table.api.EnvironmentSettings;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EnvironmentSettingsTest {
    EnvironmentSettingsTest() {
    }

    @Test
    void testFromConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setString("execution.runtime-mode", "batch");
        EnvironmentSettings settings = EnvironmentSettings.newInstance().withConfiguration(configuration).build();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)settings.isStreamingMode()).as("Expect batch mode.", new Object[0])).isFalse();
    }

    @Test
    void testGetConfiguration() {
        EnvironmentSettings settings = new EnvironmentSettings.Builder().inBatchMode().build();
        Configuration configuration = settings.getConfiguration();
        Assertions.assertThat((Comparable)((Comparable)configuration.get(ExecutionOptions.RUNTIME_MODE))).isEqualTo((Object)RuntimeExecutionMode.BATCH);
    }
}

