/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class SortQueryOperation
implements QueryOperation {
    private final List<ResolvedExpression> order;
    private final QueryOperation child;
    private final int offset;
    private final int fetch;

    public SortQueryOperation(List<ResolvedExpression> order, QueryOperation child) {
        this(order, child, -1, -1);
    }

    public SortQueryOperation(List<ResolvedExpression> order, QueryOperation child, int offset, int fetch) {
        this.order = order;
        this.child = child;
        this.offset = offset;
        this.fetch = fetch;
    }

    public List<ResolvedExpression> getOrder() {
        return this.order;
    }

    public QueryOperation getChild() {
        return this.child;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getFetch() {
        return this.fetch;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.child.getResolvedSchema();
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("order", this.order);
        args.put("offset", this.offset);
        args.put("fetch", this.fetch);
        return OperationUtils.formatWithChildren("Sort", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.singletonList(this.child);
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

