/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class ValuesQueryOperation
implements QueryOperation {
    private static final String INPUT_ALIAS = "$$T_VAL";
    private final List<List<ResolvedExpression>> values;
    private final ResolvedSchema resolvedSchema;

    public ValuesQueryOperation(List<List<ResolvedExpression>> values, ResolvedSchema resolvedSchema) {
        this.values = values;
        this.resolvedSchema = resolvedSchema;
    }

    public List<List<ResolvedExpression>> getValues() {
        return this.values;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("values", this.values);
        return OperationUtils.formatWithChildren("Values", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public String asSerializableString() {
        return String.format("SELECT %s FROM (VALUES %s\n) %s(%s)", OperationUtils.formatSelectColumns(this.resolvedSchema, INPUT_ALIAS), OperationUtils.indent(this.values.stream().map(row -> row.stream().map(ResolvedExpression::asSerializableString).collect(Collectors.joining(", ", "(", ")"))).collect(Collectors.joining(",\n"))), INPUT_ALIAS, OperationUtils.formatSelectColumns(this.resolvedSchema, null));
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValuesQueryOperation that = (ValuesQueryOperation)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.resolvedSchema, that.resolvedSchema);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.resolvedSchema);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

