/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.columnar.vector.heap;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.columnar.ColumnarMapData;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.MapColumnVector;
import org.apache.flink.table.data.columnar.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;

@Internal
public class HeapMapVector
extends AbstractHeapVector
implements WritableColumnVector,
MapColumnVector {
    private long[] offsets;
    private long[] lengths;
    private int size;
    private ColumnVector keys;
    private ColumnVector values;

    public HeapMapVector(int len, ColumnVector keys, ColumnVector values) {
        super(len);
        this.offsets = new long[len];
        this.lengths = new long[len];
        this.keys = keys;
        this.values = values;
    }

    public void setOffsets(long[] offsets) {
        this.offsets = offsets;
    }

    public void setLengths(long[] lengths) {
        this.lengths = lengths;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setKeys(ColumnVector keys) {
        this.keys = keys;
    }

    public void setValues(ColumnVector values) {
        this.values = values;
    }

    @Override
    public MapData getMap(int i) {
        long offset = this.offsets[i];
        long length = this.lengths[i];
        return new ColumnarMapData(this.keys, this.values, (int)offset, (int)length);
    }
}

