/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class DataSetQueryOperation<E>
implements QueryOperation {
    private final DataSet<E> dataSet;
    private final int[] fieldIndices;
    private final TableSchema tableSchema;

    public DataSetQueryOperation(DataSet<E> dataSet, int[] fieldIndices, TableSchema tableSchema) {
        this.dataSet = dataSet;
        this.tableSchema = tableSchema;
        this.fieldIndices = fieldIndices;
    }

    public DataSet<E> getDataSet() {
        return this.dataSet;
    }

    public int[] getFieldIndices() {
        return this.fieldIndices;
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public String asSummaryString() {
        LinkedHashMap<String, String[]> args = new LinkedHashMap<String, String[]>();
        args.put("fields", this.tableSchema.getFieldNames());
        return OperationUtils.formatWithChildren((String)"DataSet", args, this.getChildren(), Operation::asSummaryString);
    }

    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return (T)visitor.visit((QueryOperation)this);
    }
}

