/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.DescriptorValidator;
import org.apache.flink.table.sources.tsextractors.ExistingField;
import org.apache.flink.table.sources.tsextractors.StreamRecordTimestamp;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.sources.wmstrategies.AscendingTimestamps;
import org.apache.flink.table.sources.wmstrategies.BoundedOutOfOrderTimestamps;
import org.apache.flink.table.sources.wmstrategies.PreserveWatermarks;
import org.apache.flink.table.sources.wmstrategies.WatermarkStrategy;
import org.apache.flink.table.utils.EncodingUtils;

@PublicEvolving
public class RowtimeValidator
implements DescriptorValidator {
    private final boolean supportsSourceTimestamps;
    private final boolean supportsSourceWatermarks;
    private final String prefix;

    public RowtimeValidator(boolean supportsSourceTimestamps, boolean supportsSourceWatermarks) {
        this(supportsSourceTimestamps, supportsSourceWatermarks, "");
    }

    public RowtimeValidator(boolean supportsSourceTimestamps, boolean supportsSourceWatermarks, String prefix) {
        this.supportsSourceTimestamps = supportsSourceTimestamps;
        this.supportsSourceWatermarks = supportsSourceWatermarks;
        this.prefix = prefix;
    }

    public void validate(DescriptorProperties properties) {
        Consumer<String> timestampExistingField = s -> properties.validateString(this.prefix + "rowtime.timestamps.from", false, 1);
        Consumer<String> timestampCustom = s -> {
            properties.validateString(this.prefix + "rowtime.timestamps.class", false, 1);
            properties.validateString(this.prefix + "rowtime.timestamps.serialized", false, 1);
        };
        HashMap<String, Consumer<String>> timestampsValidation = new HashMap<String, Consumer<String>>();
        if (this.supportsSourceTimestamps) {
            timestampsValidation.put("from-field", timestampExistingField);
            timestampsValidation.put("from-source", DescriptorProperties.noValidation());
            timestampsValidation.put("custom", timestampCustom);
        } else {
            timestampsValidation.put("from-field", timestampExistingField);
            timestampsValidation.put("custom", timestampCustom);
        }
        properties.validateEnum(this.prefix + "rowtime.timestamps.type", false, timestampsValidation);
        Consumer<String> watermarkPeriodicBounded = s -> properties.validateLong(this.prefix + "rowtime.watermarks.delay", false, 0L);
        Consumer<String> watermarkCustom = s -> {
            properties.validateString(this.prefix + "rowtime.watermarks.class", false, 1);
            properties.validateString(this.prefix + "rowtime.watermarks.serialized", false, 1);
        };
        HashMap<String, Consumer<String>> watermarksValidation = new HashMap<String, Consumer<String>>();
        if (this.supportsSourceWatermarks) {
            watermarksValidation.put("periodic-ascending", DescriptorProperties.noValidation());
            watermarksValidation.put("periodic-bounded", watermarkPeriodicBounded);
            watermarksValidation.put("from-source", DescriptorProperties.noValidation());
            watermarksValidation.put("custom", watermarkCustom);
        } else {
            watermarksValidation.put("periodic-ascending", DescriptorProperties.noValidation());
            watermarksValidation.put("periodic-bounded", watermarkPeriodicBounded);
            watermarksValidation.put("custom", watermarkCustom);
        }
        properties.validateEnum(this.prefix + "rowtime.watermarks.type", false, watermarksValidation);
    }

    public static Optional<Tuple2<TimestampExtractor, WatermarkStrategy>> getRowtimeComponents(DescriptorProperties properties, String prefix) {
        Object strategy;
        String s;
        StreamRecordTimestamp extractor;
        Optional t = properties.getOptionalString(prefix + "rowtime.timestamps.type");
        if (!t.isPresent()) {
            return Optional.empty();
        }
        switch ((String)t.get()) {
            case "from-field": {
                String field = properties.getString(prefix + "rowtime.timestamps.from");
                extractor = new ExistingField(field);
                break;
            }
            case "from-source": {
                extractor = StreamRecordTimestamp.INSTANCE;
                break;
            }
            case "custom": {
                Class clazz = properties.getClass(prefix + "rowtime.timestamps.class", TimestampExtractor.class);
                extractor = (TimestampExtractor)EncodingUtils.decodeStringToObject((String)properties.getString(prefix + "rowtime.timestamps.serialized"), (Class)clazz);
                break;
            }
            default: {
                throw new ValidationException("Unsupported rowtime timestamps type: " + (String)t.get());
            }
        }
        switch (s = properties.getString(prefix + "rowtime.watermarks.type")) {
            case "periodic-ascending": {
                strategy = new AscendingTimestamps();
                break;
            }
            case "periodic-bounded": {
                long delay = properties.getLong(prefix + "rowtime.watermarks.delay");
                strategy = new BoundedOutOfOrderTimestamps(delay);
                break;
            }
            case "from-source": {
                strategy = PreserveWatermarks.INSTANCE;
                break;
            }
            case "custom": {
                Class clazz = properties.getClass(prefix + "rowtime.watermarks.class", WatermarkStrategy.class);
                strategy = (WatermarkStrategy)EncodingUtils.decodeStringToObject((String)properties.getString(prefix + "rowtime.watermarks.serialized"), (Class)clazz);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported rowtime timestamps type: " + s);
            }
        }
        return Optional.of(new Tuple2((Object)extractor, strategy));
    }
}

