/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.blackhole.table;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.types.RowKind;

@Internal
public class BlackHoleTableSinkFactory
implements DynamicTableSinkFactory {
    public static final String IDENTIFIER = "blackhole";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return new HashSet();
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context).validate();
        return new BlackHoleSink();
    }

    private static class BlackHoleSink
    implements DynamicTableSink {
        private BlackHoleSink() {
        }

        public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
            ChangelogMode.Builder builder = ChangelogMode.newBuilder();
            for (RowKind kind : requestedMode.getContainedKinds()) {
                if (kind == RowKind.UPDATE_BEFORE) continue;
                builder.addContainedKind(kind);
            }
            return builder.build();
        }

        public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
            return SinkFunctionProvider.of((SinkFunction<RowData>)new DiscardingSink());
        }

        public DynamicTableSink copy() {
            return new BlackHoleSink();
        }

        public String asSummaryString() {
            return "BlackHole";
        }
    }
}

