/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.runtime.operators.sink.AbstractStreamingCommitterHandler;
import org.apache.flink.util.Preconditions;

@Internal
public final class GlobalStreamingCommitterHandler<CommT, GlobalCommT>
extends AbstractStreamingCommitterHandler<CommT, GlobalCommT> {
    private final GlobalCommitter<CommT, GlobalCommT> globalCommitter;
    private boolean endOfInput;

    public GlobalStreamingCommitterHandler(GlobalCommitter<CommT, GlobalCommT> globalCommitter, SimpleVersionedSerializer<GlobalCommT> committableSerializer) {
        super(committableSerializer);
        this.globalCommitter = (GlobalCommitter)Preconditions.checkNotNull(globalCommitter);
        this.endOfInput = false;
    }

    @Override
    protected void recoveredCommittables(List<GlobalCommT> committables) throws IOException {
        super.recoveredCommittables(this.globalCommitter.filterRecoveredCommittables((List)Preconditions.checkNotNull(committables)));
    }

    @Override
    List<GlobalCommT> prepareCommit(List<CommT> input) throws IOException {
        return this.prependRecoveredCommittables(input.isEmpty() ? Collections.emptyList() : Collections.singletonList(this.globalCommitter.combine(input)));
    }

    @Override
    List<GlobalCommT> commit(List<GlobalCommT> committables) throws IOException, InterruptedException {
        return this.globalCommitter.commit((List)Preconditions.checkNotNull(committables));
    }

    @Override
    public List<GlobalCommT> endOfInput() {
        this.endOfInput = true;
        return Collections.emptyList();
    }

    @Override
    public void close() throws Exception {
        this.globalCommitter.close();
        super.close();
    }

    @Override
    public Collection<GlobalCommT> notifyCheckpointCompleted(long checkpointId) throws IOException, InterruptedException {
        super.notifyCheckpointCompleted(checkpointId);
        this.commitUpTo(checkpointId);
        if (this.endOfInput) {
            this.globalCommitter.endOfInput();
        }
        return Collections.emptyList();
    }
}

