/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.storage.FileSystemCheckpointStorage;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class CheckpointConfig
implements Serializable {
    private static final long serialVersionUID = -750378776078908147L;
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointConfig.class);
    public static final CheckpointingMode DEFAULT_MODE = CheckpointingMode.EXACTLY_ONCE;
    public static final long DEFAULT_TIMEOUT = 600000L;
    public static final long DEFAULT_MIN_PAUSE_BETWEEN_CHECKPOINTS = 0L;
    public static final int DEFAULT_MAX_CONCURRENT_CHECKPOINTS = 1;
    public static final int UNDEFINED_TOLERABLE_CHECKPOINT_NUMBER = -1;
    public static final int DEFAULT_CHECKPOINT_ID_OF_IGNORED_IN_FLIGHT_DATA = -1;
    private CheckpointingMode checkpointingMode = DEFAULT_MODE;
    private long checkpointInterval = -1L;
    private long checkpointTimeout = 600000L;
    private long minPauseBetweenCheckpoints = 0L;
    private int maxConcurrentCheckpoints = 1;
    private boolean forceCheckpointing;
    private boolean forceUnalignedCheckpoints;
    private boolean unalignedCheckpointsEnabled;
    private long checkpointIdOfIgnoredInFlightData = -1L;
    private Duration alignedCheckpointTimeout = (Duration)ExecutionCheckpointingOptions.ALIGNED_CHECKPOINT_TIMEOUT.defaultValue();
    private boolean approximateLocalRecovery;
    private ExternalizedCheckpointCleanup externalizedCheckpointCleanup;
    @Deprecated
    private boolean failOnCheckpointingErrors = true;
    private int tolerableCheckpointFailureNumber = -1;
    private transient CheckpointStorage storage;

    public CheckpointConfig(CheckpointConfig checkpointConfig) {
        Preconditions.checkNotNull((Object)checkpointConfig);
        this.checkpointInterval = checkpointConfig.checkpointInterval;
        this.checkpointingMode = checkpointConfig.checkpointingMode;
        this.checkpointTimeout = checkpointConfig.checkpointTimeout;
        this.maxConcurrentCheckpoints = checkpointConfig.maxConcurrentCheckpoints;
        this.minPauseBetweenCheckpoints = checkpointConfig.minPauseBetweenCheckpoints;
        this.tolerableCheckpointFailureNumber = checkpointConfig.tolerableCheckpointFailureNumber;
        this.unalignedCheckpointsEnabled = checkpointConfig.isUnalignedCheckpointsEnabled();
        this.alignedCheckpointTimeout = checkpointConfig.alignedCheckpointTimeout;
        this.approximateLocalRecovery = checkpointConfig.isApproximateLocalRecoveryEnabled();
        this.externalizedCheckpointCleanup = checkpointConfig.externalizedCheckpointCleanup;
        this.forceCheckpointing = checkpointConfig.forceCheckpointing;
        this.forceUnalignedCheckpoints = checkpointConfig.forceUnalignedCheckpoints;
        this.storage = checkpointConfig.getCheckpointStorage();
        this.checkpointIdOfIgnoredInFlightData = checkpointConfig.getCheckpointIdOfIgnoredInFlightData();
    }

    public CheckpointConfig() {
    }

    public void disableCheckpointing() {
        this.checkpointInterval = -1L;
    }

    public boolean isCheckpointingEnabled() {
        return this.checkpointInterval > 0L;
    }

    public CheckpointingMode getCheckpointingMode() {
        return this.checkpointingMode;
    }

    public void setCheckpointingMode(CheckpointingMode checkpointingMode) {
        this.checkpointingMode = Objects.requireNonNull(checkpointingMode);
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public void setCheckpointInterval(long checkpointInterval) {
        if (checkpointInterval < 10L) {
            throw new IllegalArgumentException(String.format("Checkpoint interval must be larger than or equal to %s ms", 10L));
        }
        this.checkpointInterval = checkpointInterval;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    public void setCheckpointTimeout(long checkpointTimeout) {
        if (checkpointTimeout < 10L) {
            throw new IllegalArgumentException(String.format("Checkpoint timeout must be larger than or equal to %s ms", 10L));
        }
        this.checkpointTimeout = checkpointTimeout;
    }

    public long getMinPauseBetweenCheckpoints() {
        return this.minPauseBetweenCheckpoints;
    }

    public void setMinPauseBetweenCheckpoints(long minPauseBetweenCheckpoints) {
        if (minPauseBetweenCheckpoints < 0L) {
            throw new IllegalArgumentException("Pause value must be zero or positive");
        }
        this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
    }

    public int getMaxConcurrentCheckpoints() {
        return this.maxConcurrentCheckpoints;
    }

    public void setMaxConcurrentCheckpoints(int maxConcurrentCheckpoints) {
        if (maxConcurrentCheckpoints < 1) {
            throw new IllegalArgumentException("The maximum number of concurrent attempts must be at least one.");
        }
        this.maxConcurrentCheckpoints = maxConcurrentCheckpoints;
    }

    @Deprecated
    @PublicEvolving
    public boolean isForceCheckpointing() {
        return this.forceCheckpointing;
    }

    @Deprecated
    @PublicEvolving
    public void setForceCheckpointing(boolean forceCheckpointing) {
        this.forceCheckpointing = forceCheckpointing;
    }

    @PublicEvolving
    public boolean isForceUnalignedCheckpoints() {
        return this.forceUnalignedCheckpoints;
    }

    @PublicEvolving
    public void setForceUnalignedCheckpoints(boolean forceUnalignedCheckpoints) {
        this.forceUnalignedCheckpoints = forceUnalignedCheckpoints;
    }

    @Deprecated
    public boolean isFailOnCheckpointingErrors() {
        return this.failOnCheckpointingErrors;
    }

    @Deprecated
    public void setFailOnCheckpointingErrors(boolean failOnCheckpointingErrors) {
        if (this.tolerableCheckpointFailureNumber != -1) {
            LOG.warn("Since tolerableCheckpointFailureNumber has been configured as {}, deprecated #setFailOnCheckpointingErrors(boolean) method would not take any effect and please use #setTolerableCheckpointFailureNumber(int) method to determine your expected behaviour when checkpoint errors on task side.", (Object)this.tolerableCheckpointFailureNumber);
            return;
        }
        this.failOnCheckpointingErrors = failOnCheckpointingErrors;
        this.tolerableCheckpointFailureNumber = failOnCheckpointingErrors ? 0 : Integer.MAX_VALUE;
    }

    public int getTolerableCheckpointFailureNumber() {
        if (this.tolerableCheckpointFailureNumber == -1) {
            return 0;
        }
        return this.tolerableCheckpointFailureNumber;
    }

    public void setTolerableCheckpointFailureNumber(int tolerableCheckpointFailureNumber) {
        if (tolerableCheckpointFailureNumber < 0) {
            throw new IllegalArgumentException("The tolerable failure checkpoint number must be non-negative.");
        }
        this.tolerableCheckpointFailureNumber = tolerableCheckpointFailureNumber;
    }

    @PublicEvolving
    public void enableExternalizedCheckpoints(ExternalizedCheckpointCleanup cleanupMode) {
        this.externalizedCheckpointCleanup = (ExternalizedCheckpointCleanup)((Object)Preconditions.checkNotNull((Object)((Object)cleanupMode)));
    }

    @PublicEvolving
    public boolean isExternalizedCheckpointsEnabled() {
        return this.externalizedCheckpointCleanup != null;
    }

    @PublicEvolving
    public void enableUnalignedCheckpoints(boolean enabled) {
        this.unalignedCheckpointsEnabled = enabled;
    }

    @PublicEvolving
    public void enableUnalignedCheckpoints() {
        this.enableUnalignedCheckpoints(true);
    }

    @PublicEvolving
    public boolean isUnalignedCheckpointsEnabled() {
        return this.unalignedCheckpointsEnabled;
    }

    @Deprecated
    @PublicEvolving
    public void setAlignmentTimeout(Duration alignmentTimeout) {
        this.alignedCheckpointTimeout = alignmentTimeout;
    }

    @Deprecated
    @PublicEvolving
    public Duration getAlignmentTimeout() {
        return this.alignedCheckpointTimeout;
    }

    @PublicEvolving
    public Duration getAlignedCheckpointTimeout() {
        return this.alignedCheckpointTimeout;
    }

    @PublicEvolving
    public void setAlignedCheckpointTimeout(Duration alignedCheckpointTimeout) {
        this.alignedCheckpointTimeout = alignedCheckpointTimeout;
    }

    @Experimental
    public boolean isApproximateLocalRecoveryEnabled() {
        return this.approximateLocalRecovery;
    }

    @Experimental
    public void enableApproximateLocalRecovery(boolean enabled) {
        this.approximateLocalRecovery = enabled;
    }

    @PublicEvolving
    public ExternalizedCheckpointCleanup getExternalizedCheckpointCleanup() {
        return this.externalizedCheckpointCleanup;
    }

    @PublicEvolving
    public void setCheckpointStorage(CheckpointStorage storage) {
        Preconditions.checkNotNull((Object)storage, (String)"Checkpoint storage must not be null");
        this.storage = storage;
    }

    @PublicEvolving
    public void setCheckpointStorage(String checkpointDirectory) {
        Preconditions.checkNotNull((Object)checkpointDirectory, (String)"Checkpoint directory must not be null");
        this.storage = new FileSystemCheckpointStorage(checkpointDirectory);
    }

    @PublicEvolving
    public void setCheckpointStorage(URI checkpointDirectory) {
        Preconditions.checkNotNull((Object)checkpointDirectory, (String)"Checkpoint directory must not be null");
        this.storage = new FileSystemCheckpointStorage(checkpointDirectory);
    }

    @PublicEvolving
    public void setCheckpointStorage(Path checkpointDirectory) {
        Preconditions.checkNotNull((Object)checkpointDirectory, (String)"Checkpoint directory must not be null");
        this.storage = new FileSystemCheckpointStorage(checkpointDirectory);
    }

    @Nullable
    @PublicEvolving
    public CheckpointStorage getCheckpointStorage() {
        return this.storage;
    }

    @PublicEvolving
    public void setCheckpointIdOfIgnoredInFlightData(long checkpointIdOfIgnoredInFlightData) {
        this.checkpointIdOfIgnoredInFlightData = checkpointIdOfIgnoredInFlightData;
    }

    @PublicEvolving
    public long getCheckpointIdOfIgnoredInFlightData() {
        return this.checkpointIdOfIgnoredInFlightData;
    }

    public void configure(ReadableConfig configuration) {
        configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINTING_MODE).ifPresent(this::setCheckpointingMode);
        configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINTING_INTERVAL).ifPresent(i -> this.setCheckpointInterval(i.toMillis()));
        configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINTING_TIMEOUT).ifPresent(t -> this.setCheckpointTimeout(t.toMillis()));
        configuration.getOptional(ExecutionCheckpointingOptions.MAX_CONCURRENT_CHECKPOINTS).ifPresent(this::setMaxConcurrentCheckpoints);
        configuration.getOptional(ExecutionCheckpointingOptions.MIN_PAUSE_BETWEEN_CHECKPOINTS).ifPresent(m -> this.setMinPauseBetweenCheckpoints(m.toMillis()));
        configuration.getOptional(ExecutionCheckpointingOptions.TOLERABLE_FAILURE_NUMBER).ifPresent(this::setTolerableCheckpointFailureNumber);
        configuration.getOptional(ExecutionCheckpointingOptions.EXTERNALIZED_CHECKPOINT).ifPresent(this::enableExternalizedCheckpoints);
        configuration.getOptional(ExecutionCheckpointingOptions.ENABLE_UNALIGNED).ifPresent(this::enableUnalignedCheckpoints);
        configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINT_ID_OF_IGNORED_IN_FLIGHT_DATA).ifPresent(this::setCheckpointIdOfIgnoredInFlightData);
        configuration.getOptional(ExecutionCheckpointingOptions.ALIGNED_CHECKPOINT_TIMEOUT).ifPresent(this::setAlignedCheckpointTimeout);
        configuration.getOptional(ExecutionCheckpointingOptions.FORCE_UNALIGNED).ifPresent(this::setForceUnalignedCheckpoints);
    }

    @PublicEvolving
    public static enum ExternalizedCheckpointCleanup {
        DELETE_ON_CANCELLATION(true),
        RETAIN_ON_CANCELLATION(false);

        private final boolean deleteOnCancellation;

        private ExternalizedCheckpointCleanup(boolean deleteOnCancellation) {
            this.deleteOnCancellation = deleteOnCancellation;
        }

        public boolean deleteOnCancellation() {
            return this.deleteOnCancellation;
        }
    }
}

