/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.LatencyMarkerEmitter;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamSourceContexts;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.OperatorChain;

@Internal
public class StreamSource<OUT, SRC extends SourceFunction<OUT>>
extends AbstractUdfStreamOperator<OUT, SRC> {
    private static final long serialVersionUID = 1L;
    private transient SourceFunction.SourceContext<OUT> ctx;
    private volatile transient boolean canceledOrStopped = false;
    private volatile transient boolean hasSentMaxWatermark = false;

    public StreamSource(SRC sourceFunction) {
        super(sourceFunction);
        this.chainingStrategy = ChainingStrategy.HEAD;
    }

    public void run(Object lockingObject, StreamStatusMaintainer streamStatusMaintainer, OperatorChain<?, ?> operatorChain) throws Exception {
        this.run(lockingObject, streamStatusMaintainer, this.output, operatorChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Object lockingObject, StreamStatusMaintainer streamStatusMaintainer, Output<StreamRecord<OUT>> collector, OperatorChain<?, ?> operatorChain) throws Exception {
        block8: {
            TimeCharacteristic timeCharacteristic = this.getOperatorConfig().getTimeCharacteristic();
            Configuration configuration = this.getContainingTask().getEnvironment().getTaskManagerInfo().getConfiguration();
            long latencyTrackingInterval = this.getExecutionConfig().isLatencyTrackingConfigured() ? this.getExecutionConfig().getLatencyTrackingInterval() : configuration.getLong(MetricOptions.LATENCY_INTERVAL);
            LatencyMarkerEmitter latencyEmitter = null;
            if (latencyTrackingInterval > 0L) {
                latencyEmitter = new LatencyMarkerEmitter(this.getProcessingTimeService(), collector::emitLatencyMarker, latencyTrackingInterval, this.getOperatorID(), this.getRuntimeContext().getIndexOfThisSubtask());
            }
            long watermarkInterval = this.getRuntimeContext().getExecutionConfig().getAutoWatermarkInterval();
            this.ctx = StreamSourceContexts.getSourceContext(timeCharacteristic, this.getProcessingTimeService(), lockingObject, streamStatusMaintainer, collector, watermarkInterval, -1L);
            try {
                ((SourceFunction)this.userFunction).run(this.ctx);
                if (this.isCanceledOrStopped()) break block8;
                Object object = lockingObject;
                synchronized (object) {
                    operatorChain.setIgnoreEndOfInput(false);
                    operatorChain.endInput(1);
                }
            }
            finally {
                if (latencyEmitter != null) {
                    latencyEmitter.close();
                }
            }
        }
    }

    public void advanceToEndOfEventTime() {
        if (!this.hasSentMaxWatermark) {
            this.ctx.emitWatermark(Watermark.MAX_WATERMARK);
            this.hasSentMaxWatermark = true;
        }
    }

    @Override
    public void close() throws Exception {
        try {
            super.close();
            if (!this.isCanceledOrStopped() && this.ctx != null) {
                this.advanceToEndOfEventTime();
            }
        }
        finally {
            if (this.ctx != null) {
                this.ctx.close();
            }
        }
    }

    public void cancel() {
        this.markCanceledOrStopped();
        ((SourceFunction)this.userFunction).cancel();
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    protected void markCanceledOrStopped() {
        this.canceledOrStopped = true;
    }

    protected boolean isCanceledOrStopped() {
        return this.canceledOrStopped;
    }
}

