/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializerTypeSerializerProxy;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SerializableSupplier;

@Internal
public final class CommittableTypeInformation<CommT>
extends TypeInformation<CommT> {
    private final Class<CommT> typeClazz;
    private final SerializableSupplier<SimpleVersionedSerializer<CommT>> serializerSerializableSupplier;

    public CommittableTypeInformation(Class<CommT> typeClazz, SerializableSupplier<SimpleVersionedSerializer<CommT>> serializerSerializableSupplier) {
        this.typeClazz = (Class)Preconditions.checkNotNull(typeClazz);
        this.serializerSerializableSupplier = (SerializableSupplier)Preconditions.checkNotNull(serializerSerializableSupplier);
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<CommT> getTypeClass() {
        return this.typeClazz;
    }

    public boolean isKeyType() {
        return Comparable.class.isAssignableFrom(this.typeClazz);
    }

    public TypeSerializer<CommT> createSerializer(ExecutionConfig config) {
        return new SimpleVersionedSerializerTypeSerializerProxy(this.serializerSerializableSupplier);
    }

    public String toString() {
        return this.typeClazz.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof CommittableTypeInformation) {
            if (this == o) {
                return true;
            }
            CommittableTypeInformation that = (CommittableTypeInformation)((Object)o);
            return this.typeClazz.equals(that.typeClazz) && ((SimpleVersionedSerializer)this.serializerSerializableSupplier.get()).equals(that.serializerSerializableSupplier.get());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.typeClazz, this.serializerSerializableSupplier.get());
    }

    public boolean canEqual(Object obj) {
        return obj instanceof CommittableTypeInformation;
    }
}

