/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.experimental;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;

@Experimental
public class SocketStreamIterator<T>
implements Iterator<T> {
    private final ServerSocket socket;
    private final TypeSerializer<T> serializer;
    private DataInputViewStreamWrapper inStream;
    private T next;
    private Socket connectedSocket;
    private volatile Throwable error;

    public SocketStreamIterator(TypeSerializer<T> serializer) throws IOException {
        this(0, null, serializer);
    }

    public SocketStreamIterator(int port, InetAddress address, TypeSerializer<T> serializer) throws IOException {
        this.serializer = serializer;
        try {
            this.socket = new ServerSocket(port, 1, address);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open socket to receive back stream results");
        }
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public InetAddress getBindAddress() {
        return this.socket.getInetAddress();
    }

    public void close() {
        if (this.connectedSocket != null) {
            try {
                this.connectedSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            try {
                this.next = this.readNextFromStream();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to receive next element: " + e.getMessage(), e);
            }
        }
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T current = this.next;
            this.next = null;
            return current;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private T readNextFromStream() throws Exception {
        try {
            if (this.inStream == null) {
                this.connectedSocket = this.socket.accept();
                this.inStream = new DataInputViewStreamWrapper(this.connectedSocket.getInputStream());
            }
            return (T)this.serializer.deserialize((DataInputView)this.inStream);
        }
        catch (EOFException e) {
            try {
                this.connectedSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
        catch (Exception e) {
            if (this.error == null) {
                throw e;
            }
            throw new Exception("Receiving stream failed: " + this.error.getMessage(), this.error);
        }
    }

    public void notifyOfError(Throwable error) {
        if (error != null && this.error == null) {
            this.error = error;
            try {
                this.connectedSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

