/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;

@Internal
public class SplitTransformation<T>
extends Transformation<T> {
    private final Transformation<T> input;
    private final OutputSelector<T> outputSelector;

    public SplitTransformation(Transformation<T> input, OutputSelector<T> outputSelector) {
        super("Split", input.getOutputType(), input.getParallelism());
        this.input = input;
        this.outputSelector = outputSelector;
    }

    public Transformation<T> getInput() {
        return this.input;
    }

    public OutputSelector<T> getOutputSelector() {
        return this.outputSelector;
    }

    public Collection<Transformation<?>> getTransitivePredecessors() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }
}

