/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;

@Internal
public class SourceTransformation<T>
extends PhysicalTransformation<T> {
    private final StreamOperatorFactory<T> operatorFactory;

    public SourceTransformation(String name, StreamSource<T, ?> operator, TypeInformation<T> outputType, int parallelism) {
        this(name, SimpleOperatorFactory.of(operator), outputType, parallelism);
    }

    public SourceTransformation(String name, StreamOperatorFactory<T> operatorFactory, TypeInformation<T> outputType, int parallelism) {
        super(name, outputType, parallelism);
        this.operatorFactory = operatorFactory;
    }

    @VisibleForTesting
    public StreamSource<T, ?> getOperator() {
        return (StreamSource)((SimpleOperatorFactory)this.operatorFactory).getOperator();
    }

    public StreamOperatorFactory<T> getOperatorFactory() {
        return this.operatorFactory;
    }

    public Collection<Transformation<?>> getTransitivePredecessors() {
        return Collections.singleton(this);
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        this.operatorFactory.setChainingStrategy(strategy);
    }
}

