/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.streaming.api.functions.sink.OutputFormatSinkFunction;
import org.apache.flink.streaming.api.functions.source.InputFormatSourceFunction;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.streaming.api.operators.SetupableStreamOperator;
import org.apache.flink.streaming.api.operators.SimpleInputFormatOperatorFactory;
import org.apache.flink.streaming.api.operators.SimpleOutputFormatOperatorFactory;
import org.apache.flink.streaming.api.operators.SimpleUdfStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.Preconditions;

@Internal
public class SimpleOperatorFactory<OUT>
implements StreamOperatorFactory<OUT> {
    private final StreamOperator<OUT> operator;

    public static <OUT> SimpleOperatorFactory<OUT> of(StreamOperator<OUT> operator) {
        if (operator == null) {
            return null;
        }
        if (operator instanceof StreamSource && ((StreamSource)operator).getUserFunction() instanceof InputFormatSourceFunction) {
            return new SimpleInputFormatOperatorFactory((StreamSource)operator);
        }
        if (operator instanceof StreamSink && ((StreamSink)operator).getUserFunction() instanceof OutputFormatSinkFunction) {
            return new SimpleOutputFormatOperatorFactory((StreamSink)operator);
        }
        if (operator instanceof AbstractUdfStreamOperator) {
            return new SimpleUdfStreamOperatorFactory((AbstractUdfStreamOperator)operator);
        }
        return new SimpleOperatorFactory<OUT>(operator);
    }

    protected SimpleOperatorFactory(StreamOperator<OUT> operator) {
        this.operator = (StreamOperator)Preconditions.checkNotNull(operator);
    }

    public StreamOperator<OUT> getOperator() {
        return this.operator;
    }

    @Override
    public <T extends StreamOperator<OUT>> T createStreamOperator(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<OUT>> output) {
        if (this.operator instanceof SetupableStreamOperator) {
            ((SetupableStreamOperator)((Object)this.operator)).setup(containingTask, config, output);
        }
        return (T)this.operator;
    }

    @Override
    public void setChainingStrategy(ChainingStrategy strategy) {
        this.operator.setChainingStrategy(strategy);
    }

    @Override
    public ChainingStrategy getChainingStrategy() {
        return this.operator.getChainingStrategy();
    }

    @Override
    public boolean isStreamSource() {
        return this.operator instanceof StreamSource;
    }

    @Override
    public boolean isOutputTypeConfigurable() {
        return this.operator instanceof OutputTypeConfigurable;
    }

    @Override
    public void setOutputType(TypeInformation<OUT> type, ExecutionConfig executionConfig) {
        ((OutputTypeConfigurable)((Object)this.operator)).setOutputType(type, executionConfig);
    }

    @Override
    public boolean isInputTypeConfigurable() {
        return this.operator instanceof InputTypeConfigurable;
    }

    @Override
    public void setInputType(TypeInformation<?> type, ExecutionConfig executionConfig) {
        ((InputTypeConfigurable)this.operator).setInputType(type, executionConfig);
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return this.operator.getClass();
    }
}

