/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class RebalancePartitioner<T>
extends StreamPartitioner<T> {
    private static final long serialVersionUID = 1L;
    private final int[] returnArray = new int[]{0x7FFFFFFE};

    public int[] selectChannels(SerializationDelegate<StreamRecord<T>> record, int numChannels) {
        this.returnArray[0] = this.returnArray[0] + 1;
        int newChannel = this.returnArray[0];
        if (newChannel >= numChannels) {
            this.returnArray[0] = RebalancePartitioner.resetValue(numChannels, newChannel);
        }
        return this.returnArray;
    }

    private static int resetValue(int numChannels, int newChannel) {
        if (newChannel == Integer.MAX_VALUE) {
            return ThreadLocalRandom.current().nextInt(numChannels);
        }
        return 0;
    }

    @Override
    public StreamPartitioner<T> copy() {
        return this;
    }

    public String toString() {
        return "REBALANCE";
    }
}

