/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.MissingTypeInfo;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class StreamTransformation<T> {
    protected static Integer idCounter = 0;
    protected final int id;
    protected String name;
    protected TypeInformation<T> outputType;
    protected boolean typeUsed;
    private int parallelism;
    private int maxParallelism = -1;
    private ResourceSpec minResources = ResourceSpec.DEFAULT;
    private ResourceSpec preferredResources = ResourceSpec.DEFAULT;
    private String uid;
    private String userProvidedNodeHash;
    protected long bufferTimeout = -1L;
    private String slotSharingGroup;
    @Nullable
    private String coLocationGroupKey;

    public static int getNewNodeId() {
        Integer n = idCounter;
        Integer n2 = idCounter = Integer.valueOf(idCounter + 1);
        return idCounter;
    }

    public StreamTransformation(String name, TypeInformation<T> outputType, int parallelism) {
        this.id = StreamTransformation.getNewNodeId();
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.outputType = outputType;
        this.parallelism = parallelism;
        this.slotSharingGroup = null;
    }

    public int getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 || parallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be at least one, or ExecutionConfig.PARALLELISM_DEFAULT (use system default).");
        this.parallelism = parallelism;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public void setMaxParallelism(int maxParallelism) {
        Preconditions.checkArgument((maxParallelism > 0 && maxParallelism <= 32768 ? 1 : 0) != 0, (Object)("Maximum parallelism must be between 1 and 32768. Found: " + maxParallelism));
        this.maxParallelism = maxParallelism;
    }

    public void setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        this.minResources = (ResourceSpec)Preconditions.checkNotNull((Object)minResources);
        this.preferredResources = (ResourceSpec)Preconditions.checkNotNull((Object)preferredResources);
    }

    public ResourceSpec getMinResources() {
        return this.minResources;
    }

    public ResourceSpec getPreferredResources() {
        return this.preferredResources;
    }

    public void setUidHash(String uidHash) {
        Preconditions.checkNotNull((Object)uidHash);
        Preconditions.checkArgument((boolean)uidHash.matches("^[0-9A-Fa-f]{32}$"), (Object)("Node hash must be a 32 character String that describes a hex code. Found: " + uidHash));
        this.userProvidedNodeHash = uidHash;
    }

    public String getUserProvidedNodeHash() {
        return this.userProvidedNodeHash;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUid() {
        return this.uid;
    }

    public String getSlotSharingGroup() {
        return this.slotSharingGroup;
    }

    public void setSlotSharingGroup(String slotSharingGroup) {
        this.slotSharingGroup = slotSharingGroup;
    }

    public void setCoLocationGroupKey(@Nullable String coLocationGroupKey) {
        this.coLocationGroupKey = coLocationGroupKey;
    }

    @Nullable
    public String getCoLocationGroupKey() {
        return this.coLocationGroupKey;
    }

    public void setOutputType(TypeInformation<T> outputType) {
        if (this.typeUsed) {
            throw new IllegalStateException("TypeInformation cannot be filled in for the type after it has been used. Please make sure that the type info hints are the first call after the transformation function, before any access to types or semantic properties, etc.");
        }
        this.outputType = outputType;
    }

    public TypeInformation<T> getOutputType() {
        if (this.outputType instanceof MissingTypeInfo) {
            MissingTypeInfo typeInfo = (MissingTypeInfo)this.outputType;
            throw new InvalidTypesException("The return type of function '" + typeInfo.getFunctionName() + "' could not be determined automatically, due to type erasure. You can give type information hints by using the returns(...) method on the result of the transformation call, or by letting your function implement the 'ResultTypeQueryable' interface.", (Throwable)typeInfo.getTypeException());
        }
        this.typeUsed = true;
        return this.outputType;
    }

    public abstract void setChainingStrategy(ChainingStrategy var1);

    public void setBufferTimeout(long bufferTimeout) {
        Preconditions.checkArgument((bufferTimeout >= -1L ? 1 : 0) != 0);
        this.bufferTimeout = bufferTimeout;
    }

    public long getBufferTimeout() {
        return this.bufferTimeout;
    }

    public abstract Collection<StreamTransformation<?>> getTransitivePredecessors();

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.id + ", name='" + this.name + '\'' + ", outputType=" + this.outputType + ", parallelism=" + this.parallelism + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamTransformation)) {
            return false;
        }
        StreamTransformation that = (StreamTransformation)o;
        if (this.bufferTimeout != that.bufferTimeout) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.parallelism != that.parallelism) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.outputType != null ? this.outputType.equals(that.outputType) : that.outputType == null;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.outputType != null ? this.outputType.hashCode() : 0);
        result = 31 * result + this.parallelism;
        result = 31 * result + (int)(this.bufferTimeout ^ this.bufferTimeout >>> 32);
        return result;
    }
}

