/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.assigners.SlidingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.util.StreamRecordMatchers;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SlidingEventTimeWindowsTest
extends TestLogger {
    @Test
    public void testWindowAssignment() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        SlidingEventTimeWindows assigner = SlidingEventTimeWindows.of((Time)Time.milliseconds((long)5000L), (Time)Time.milliseconds((long)1000L));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 0L, mockContext), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StreamRecordMatchers.timeWindow(-4000L, 1000L), StreamRecordMatchers.timeWindow(-3000L, 2000L), StreamRecordMatchers.timeWindow(-2000L, 3000L), StreamRecordMatchers.timeWindow(-1000L, 4000L), StreamRecordMatchers.timeWindow(0L, 5000L)}));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 4999L, mockContext), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StreamRecordMatchers.timeWindow(0L, 5000L), StreamRecordMatchers.timeWindow(1000L, 6000L), StreamRecordMatchers.timeWindow(2000L, 7000L), StreamRecordMatchers.timeWindow(3000L, 8000L), StreamRecordMatchers.timeWindow(4000L, 9000L)}));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 5000L, mockContext), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StreamRecordMatchers.timeWindow(1000L, 6000L), StreamRecordMatchers.timeWindow(2000L, 7000L), StreamRecordMatchers.timeWindow(3000L, 8000L), StreamRecordMatchers.timeWindow(4000L, 9000L), StreamRecordMatchers.timeWindow(5000L, 10000L)}));
    }

    @Test
    public void testWindowAssignmentWithOffset() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        SlidingEventTimeWindows assigner = SlidingEventTimeWindows.of((Time)Time.milliseconds((long)5000L), (Time)Time.milliseconds((long)1000L), (Time)Time.milliseconds((long)100L));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 100L, mockContext), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StreamRecordMatchers.timeWindow(-3900L, 1100L), StreamRecordMatchers.timeWindow(-2900L, 2100L), StreamRecordMatchers.timeWindow(-1900L, 3100L), StreamRecordMatchers.timeWindow(-900L, 4100L), StreamRecordMatchers.timeWindow(100L, 5100L)}));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 5099L, mockContext), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StreamRecordMatchers.timeWindow(100L, 5100L), StreamRecordMatchers.timeWindow(1100L, 6100L), StreamRecordMatchers.timeWindow(2100L, 7100L), StreamRecordMatchers.timeWindow(3100L, 8100L), StreamRecordMatchers.timeWindow(4100L, 9100L)}));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 5100L, mockContext), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StreamRecordMatchers.timeWindow(1100L, 6100L), StreamRecordMatchers.timeWindow(2100L, 7100L), StreamRecordMatchers.timeWindow(3100L, 8100L), StreamRecordMatchers.timeWindow(4100L, 9100L), StreamRecordMatchers.timeWindow(5100L, 10100L)}));
    }

    @Test
    public void testWindowAssignmentWithNegativeOffset() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        SlidingEventTimeWindows assigner = SlidingEventTimeWindows.of((Time)Time.milliseconds((long)5000L), (Time)Time.milliseconds((long)1000L), (Time)Time.milliseconds((long)-100L));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 0L, mockContext), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StreamRecordMatchers.timeWindow(-4100L, 900L), StreamRecordMatchers.timeWindow(-3100L, 1900L), StreamRecordMatchers.timeWindow(-2100L, 2900L), StreamRecordMatchers.timeWindow(-1100L, 3900L), StreamRecordMatchers.timeWindow(-100L, 4900L)}));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 4899L, mockContext), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StreamRecordMatchers.timeWindow(-100L, 4900L), StreamRecordMatchers.timeWindow(900L, 5900L), StreamRecordMatchers.timeWindow(1900L, 6900L), StreamRecordMatchers.timeWindow(2900L, 7900L), StreamRecordMatchers.timeWindow(3900L, 8900L)}));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 4900L, mockContext), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StreamRecordMatchers.timeWindow(900L, 5900L), StreamRecordMatchers.timeWindow(1900L, 6900L), StreamRecordMatchers.timeWindow(2900L, 7900L), StreamRecordMatchers.timeWindow(3900L, 8900L), StreamRecordMatchers.timeWindow(4900L, 9900L)}));
    }

    @Test
    public void testTimeUnits() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        SlidingEventTimeWindows assigner = SlidingEventTimeWindows.of((Time)Time.seconds((long)5L), (Time)Time.seconds((long)1L), (Time)Time.milliseconds((long)500L));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 100L, mockContext), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StreamRecordMatchers.timeWindow(-4500L, 500L), StreamRecordMatchers.timeWindow(-3500L, 1500L), StreamRecordMatchers.timeWindow(-2500L, 2500L), StreamRecordMatchers.timeWindow(-1500L, 3500L), StreamRecordMatchers.timeWindow(-500L, 4500L)}));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 5499L, mockContext), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StreamRecordMatchers.timeWindow(500L, 5500L), StreamRecordMatchers.timeWindow(1500L, 6500L), StreamRecordMatchers.timeWindow(2500L, 7500L), StreamRecordMatchers.timeWindow(3500L, 8500L), StreamRecordMatchers.timeWindow(4500L, 9500L)}));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 5100L, mockContext), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{StreamRecordMatchers.timeWindow(500L, 5500L), StreamRecordMatchers.timeWindow(1500L, 6500L), StreamRecordMatchers.timeWindow(2500L, 7500L), StreamRecordMatchers.timeWindow(3500L, 8500L), StreamRecordMatchers.timeWindow(4500L, 9500L)}));
    }

    @Test
    public void testInvalidParameters() {
        try {
            SlidingEventTimeWindows.of((Time)Time.seconds((long)-2L), (Time)Time.seconds((long)1L));
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"abs(offset) < slide and size > 0"));
        }
        try {
            SlidingEventTimeWindows.of((Time)Time.seconds((long)2L), (Time)Time.seconds((long)-1L));
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"abs(offset) < slide and size > 0"));
        }
        try {
            SlidingEventTimeWindows.of((Time)Time.seconds((long)-20L), (Time)Time.seconds((long)10L), (Time)Time.seconds((long)-1L));
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"abs(offset) < slide and size > 0"));
        }
        try {
            SlidingEventTimeWindows.of((Time)Time.seconds((long)20L), (Time)Time.seconds((long)10L), (Time)Time.seconds((long)-11L));
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"abs(offset) < slide and size > 0"));
        }
        try {
            SlidingEventTimeWindows.of((Time)Time.seconds((long)20L), (Time)Time.seconds((long)10L), (Time)Time.seconds((long)11L));
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"abs(offset) < slide and size > 0"));
        }
    }

    @Test
    public void testProperties() {
        SlidingEventTimeWindows assigner = SlidingEventTimeWindows.of((Time)Time.seconds((long)5L), (Time)Time.milliseconds((long)100L));
        Assert.assertTrue((boolean)assigner.isEventTime());
        Assert.assertEquals((Object)new TimeWindow.Serializer(), (Object)assigner.getWindowSerializer(new ExecutionConfig()));
        Assert.assertThat((Object)assigner.getDefaultTrigger((StreamExecutionEnvironment)Mockito.mock(StreamExecutionEnvironment.class)), (Matcher)Matchers.instanceOf(EventTimeTrigger.class));
    }
}

