/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.Collection;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.ContinuousEventTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.TriggerTestHarness;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;
import org.junit.Test;

public class ContinuousEventTimeTriggerTest {
    @Test
    public void testTriggerHandlesAllOnTimerCalls() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ContinuousEventTimeTrigger.of((Time)Time.milliseconds((long)5L)), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
        testHarness.advanceWatermark(10L);
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        testHarness.invokeOnEventTime(20L, new TimeWindow(0L, 2L));
    }

    @Test
    public void testWindowSeparationAndFiring() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ContinuousEventTimeTrigger.of((Time)Time.hours((long)1L)), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)4L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        Collection triggerResults = testHarness.advanceWatermark(2L);
        boolean sawFiring = false;
        for (Tuple2 r : triggerResults) {
            if (!((TimeWindow)r.f0).equals((Object)new TimeWindow(0L, 2L))) continue;
            sawFiring = true;
            Assert.assertTrue((boolean)((TriggerResult)r.f1).equals((Object)TriggerResult.FIRE));
        }
        Assert.assertTrue((boolean)sawFiring);
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)3L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        triggerResults = testHarness.advanceWatermark(4L);
        sawFiring = false;
        for (Tuple2 r : triggerResults) {
            if (!((TimeWindow)r.f0).equals((Object)new TimeWindow(2L, 4L))) continue;
            sawFiring = true;
            Assert.assertTrue((boolean)((TriggerResult)r.f1).equals((Object)TriggerResult.FIRE));
        }
        Assert.assertTrue((boolean)sawFiring);
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers());
    }

    @Test
    public void testLateElementTriggersImmediately() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ContinuousEventTimeTrigger.of((Time)Time.hours((long)1L)), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        testHarness.advanceWatermark(2L);
        Assert.assertEquals((Object)TriggerResult.FIRE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers());
    }

    @Test
    public void testClear() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ContinuousEventTimeTrigger.of((Time)Time.hours((long)1L)), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)4L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        testHarness.clearTriggerState(new TimeWindow(2L, 4L));
        Assert.assertEquals((long)1L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)3L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        testHarness.clearTriggerState(new TimeWindow(0L, 2L));
        Assert.assertEquals((long)0L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers());
    }

    @Test
    public void testMergingWindows() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ContinuousEventTimeTrigger.of((Time)Time.hours((long)1L)), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assert.assertTrue((boolean)ContinuousEventTimeTrigger.of((Time)Time.hours((long)1L)).canMerge());
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)2L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)4L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        testHarness.mergeWindows(new TimeWindow(0L, 4L), Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 2L), new TimeWindow(2L, 4L)}));
        Assert.assertEquals((long)1L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)5L, (long)testHarness.numEventTimeTimers());
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)2L, (long)testHarness.numEventTimeTimers(new TimeWindow(2L, 4L)));
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 4L)));
        Collection triggerResults = testHarness.advanceWatermark(4L);
        boolean sawFiring = false;
        for (Tuple2 r : triggerResults) {
            if (!((TimeWindow)r.f0).equals((Object)new TimeWindow(0L, 4L))) continue;
            sawFiring = true;
            Assert.assertTrue((boolean)((TriggerResult)r.f1).equals((Object)TriggerResult.FIRE));
        }
        Assert.assertTrue((boolean)sawFiring);
        Assert.assertEquals((long)1L, (long)testHarness.numStateEntries());
        Assert.assertEquals((long)0L, (long)testHarness.numProcessingTimeTimers());
        Assert.assertEquals((long)1L, (long)testHarness.numEventTimeTimers());
    }
}

