/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.runtime.operators.sink.TestSink;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

class SinkTestUtil {
    SinkTestUtil() {
    }

    static StreamRecord<byte[]> committableRecord(String element) {
        return new StreamRecord((Object)SinkTestUtil.toBytes(element));
    }

    static List<StreamRecord<byte[]>> committableRecords(Collection<String> elements) {
        return elements.stream().map(SinkTestUtil::committableRecord).collect(Collectors.toList());
    }

    static List<byte[]> toBytes(String ... elements) {
        return Arrays.stream(elements).map(SinkTestUtil::toBytes).collect(Collectors.toList());
    }

    static List<byte[]> toBytes(Collection<String> elements) {
        return elements.stream().map(SinkTestUtil::toBytes).collect(Collectors.toList());
    }

    static byte[] toBytes(String obj) {
        try {
            return SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)TestSink.StringCommittableSerializer.INSTANCE, (Object)obj);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static List<String> fromRecords(Collection<StreamRecord<byte[]>> elements) {
        return elements.stream().map(SinkTestUtil::fromRecord).collect(Collectors.toList());
    }

    static List<StreamElement> fromOutput(Collection<Object> elements) {
        return elements.stream().map(element -> {
            if (element instanceof StreamRecord) {
                return new StreamRecord((Object)SinkTestUtil.fromRecord((StreamRecord<byte[]>)((StreamRecord)element)));
            }
            return (StreamElement)element;
        }).collect(Collectors.toList());
    }

    static String fromRecord(StreamRecord<byte[]> obj) {
        return SinkTestUtil.fromBytes((byte[])obj.getValue());
    }

    static String fromBytes(byte[] obj) {
        try {
            return (String)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)TestSink.StringCommittableSerializer.INSTANCE, (byte[])obj);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

