/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;

public class MockInputGate
extends IndexedInputGate {
    private final int numberOfChannels;
    private final Queue<BufferOrEvent> bufferOrEvents;
    private final boolean[] closed;
    private final boolean finishAfterLastBuffer;
    private ArrayList<Integer> lastUnblockedChannels = new ArrayList();
    private Set<Integer> blockedChannels = new HashSet<Integer>();

    public MockInputGate(int numberOfChannels, List<BufferOrEvent> bufferOrEvents) {
        this(numberOfChannels, bufferOrEvents, true);
    }

    public MockInputGate(int numberOfChannels, List<BufferOrEvent> bufferOrEvents, boolean finishAfterLastBuffer) {
        this.numberOfChannels = numberOfChannels;
        this.bufferOrEvents = new ArrayDeque<BufferOrEvent>(bufferOrEvents);
        this.closed = new boolean[numberOfChannels];
        this.finishAfterLastBuffer = finishAfterLastBuffer;
        this.availabilityHelper.resetAvailable();
    }

    public void setup() {
    }

    public CompletableFuture<Void> getStateConsumedFuture() {
        return CompletableFuture.completedFuture(null);
    }

    public void finishReadRecoveredState() {
    }

    public void requestPartitions() {
    }

    public int getNumberOfInputChannels() {
        return this.numberOfChannels;
    }

    public InputChannel getChannel(int channelIndex) {
        throw new UnsupportedOperationException();
    }

    public List<InputChannelInfo> getChannelInfos() {
        return IntStream.range(0, this.numberOfChannels).mapToObj(channelIndex -> new InputChannelInfo(0, channelIndex)).collect(Collectors.toList());
    }

    public void checkpointStopped(long cancelledCheckpointId) {
    }

    public boolean isFinished() {
        return this.finishAfterLastBuffer && this.bufferOrEvents.isEmpty();
    }

    public boolean hasReceivedEndOfData() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Optional<BufferOrEvent> getNext() {
        BufferOrEvent next = this.bufferOrEvents.poll();
        if (!this.finishAfterLastBuffer && this.bufferOrEvents.isEmpty()) {
            this.availabilityHelper.resetUnavailable();
        }
        if (next == null) {
            return Optional.empty();
        }
        int channelIdx = next.getChannelInfo().getInputChannelIdx();
        if (this.closed[channelIdx]) {
            throw new RuntimeException("Inconsistent: Channel " + channelIdx + " has data even though it is already closed.");
        }
        if (next.isEvent() && next.getEvent() instanceof EndOfPartitionEvent) {
            this.closed[channelIdx] = true;
        }
        return Optional.of(next);
    }

    public Optional<BufferOrEvent> pollNext() {
        return this.getNext();
    }

    public void sendTaskEvent(TaskEvent event) {
    }

    public void resumeConsumption(InputChannelInfo channelInfo) {
        this.lastUnblockedChannels.add(channelInfo.getInputChannelIdx());
        this.blockedChannels.remove(channelInfo.getInputChannelIdx());
    }

    public void blockConsumption(InputChannelInfo channelInfo) {
        super.blockConsumption(channelInfo);
        if (!this.blockedChannels.add(channelInfo.getInputChannelIdx())) {
            throw new IllegalArgumentException("Blocking the same channel multiple times");
        }
    }

    public int getBuffersInUseCount() {
        return 0;
    }

    public void announceBufferSize(int bufferSize) {
    }

    public Set<Integer> getBlockedChannels() {
        return this.blockedChannels;
    }

    public void acknowledgeAllRecordsProcessed(InputChannelInfo channelInfo) throws IOException {
        throw new UnsupportedEncodingException();
    }

    public void close() {
    }

    public int getGateIndex() {
        return 0;
    }

    public List<InputChannelInfo> getUnfinishedChannels() {
        return Collections.emptyList();
    }
}

