/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sort;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.streaming.api.operators.sort.BytesKeyNormalizationUtil;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

final class VariableLengthByteKeyComparator<IN>
extends TypeComparator<Tuple2<byte[], StreamRecord<IN>>> {
    private byte[] keyReference;
    private long timestampReference;

    VariableLengthByteKeyComparator() {
    }

    public int hash(Tuple2<byte[], StreamRecord<IN>> record) {
        return record.hashCode();
    }

    public void setReference(Tuple2<byte[], StreamRecord<IN>> toCompare) {
        this.keyReference = Arrays.copyOf((byte[])toCompare.f0, ((byte[])toCompare.f0).length);
        this.timestampReference = ((StreamRecord)toCompare.f1).asRecord().getTimestamp();
    }

    public boolean equalToReference(Tuple2<byte[], StreamRecord<IN>> candidate) {
        return Arrays.equals(this.keyReference, (byte[])candidate.f0) && this.timestampReference == ((StreamRecord)candidate.f1).asRecord().getTimestamp();
    }

    public int compareToReference(TypeComparator<Tuple2<byte[], StreamRecord<IN>>> referencedComparator) {
        byte[] otherKey = ((VariableLengthByteKeyComparator)referencedComparator).keyReference;
        long otherTimestamp = ((VariableLengthByteKeyComparator)referencedComparator).timestampReference;
        int keyCmp = this.compare(otherKey, this.keyReference);
        if (keyCmp != 0) {
            return keyCmp;
        }
        return Long.compare(otherTimestamp, this.timestampReference);
    }

    public int compare(Tuple2<byte[], StreamRecord<IN>> first, Tuple2<byte[], StreamRecord<IN>> second) {
        int keyCmp = this.compare((byte[])first.f0, (byte[])second.f0);
        if (keyCmp != 0) {
            return keyCmp;
        }
        return Long.compare(((StreamRecord)first.f1).asRecord().getTimestamp(), ((StreamRecord)second.f1).asRecord().getTimestamp());
    }

    private int compare(byte[] first, byte[] second) {
        int firstLength = first.length;
        int secondLength = second.length;
        int minLength = Math.min(firstLength, secondLength);
        for (int i = 0; i < minLength; ++i) {
            int cmp = Byte.compare(first[i], second[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(firstLength, secondLength);
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int firstLength = firstSource.readInt();
        int secondLength = secondSource.readInt();
        int minLength = Math.min(firstLength, secondLength);
        while (minLength-- > 0) {
            byte secondValue;
            byte firstValue = firstSource.readByte();
            int cmp = Byte.compare(firstValue, secondValue = secondSource.readByte());
            if (cmp == 0) continue;
            return cmp;
        }
        int lengthCompare = Integer.compare(firstLength, secondLength);
        if (lengthCompare != 0) {
            return lengthCompare;
        }
        return Long.compare(firstSource.readLong(), secondSource.readLong());
    }

    public boolean supportsNormalizedKey() {
        return true;
    }

    public int getNormalizeKeyLen() {
        return Integer.MAX_VALUE;
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return true;
    }

    public void putNormalizedKey(Tuple2<byte[], StreamRecord<IN>> record, MemorySegment target, int offset, int numBytes) {
        BytesKeyNormalizationUtil.putNormalizedKey(record, ((byte[])record.f0).length, target, offset, numBytes);
    }

    public boolean invertNormalizedKey() {
        return false;
    }

    public TypeComparator<Tuple2<byte[], StreamRecord<IN>>> duplicate() {
        return new VariableLengthByteKeyComparator<IN>();
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    public TypeComparator<?>[] getFlatComparators() {
        return new TypeComparator[]{this};
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(Tuple2<byte[], StreamRecord<IN>> record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Tuple2<byte[], StreamRecord<IN>> readWithKeyDenormalization(Tuple2<byte[], StreamRecord<IN>> reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

