/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;

public class OperatorSnapshotFinalizer {
    private final OperatorSubtaskState jobManagerOwnedState;
    private final OperatorSubtaskState taskLocalState;

    public OperatorSnapshotFinalizer(@Nonnull OperatorSnapshotFutures snapshotFutures) throws ExecutionException, InterruptedException {
        SnapshotResult keyedManaged = (SnapshotResult)FutureUtils.runIfNotDoneAndGet(snapshotFutures.getKeyedStateManagedFuture());
        SnapshotResult keyedRaw = (SnapshotResult)FutureUtils.runIfNotDoneAndGet(snapshotFutures.getKeyedStateRawFuture());
        SnapshotResult operatorManaged = (SnapshotResult)FutureUtils.runIfNotDoneAndGet(snapshotFutures.getOperatorStateManagedFuture());
        SnapshotResult operatorRaw = (SnapshotResult)FutureUtils.runIfNotDoneAndGet(snapshotFutures.getOperatorStateRawFuture());
        SnapshotResult<StateObjectCollection<InputChannelStateHandle>> inputChannel = snapshotFutures.getInputChannelStateFuture().get();
        SnapshotResult<StateObjectCollection<ResultSubpartitionStateHandle>> resultSubpartition = snapshotFutures.getResultSubpartitionStateFuture().get();
        this.jobManagerOwnedState = OperatorSubtaskState.builder().setManagedOperatorState(StateObjectCollection.singletonOrEmpty((StateObject)operatorManaged.getJobManagerOwnedSnapshot())).setRawOperatorState(StateObjectCollection.singletonOrEmpty((StateObject)operatorRaw.getJobManagerOwnedSnapshot())).setManagedKeyedState(StateObjectCollection.singletonOrEmpty((StateObject)keyedManaged.getJobManagerOwnedSnapshot())).setRawKeyedState(StateObjectCollection.singletonOrEmpty((StateObject)keyedRaw.getJobManagerOwnedSnapshot())).setInputChannelState(StateObjectCollection.emptyIfNull((StateObjectCollection)((StateObjectCollection)inputChannel.getJobManagerOwnedSnapshot()))).setResultSubpartitionState(StateObjectCollection.emptyIfNull((StateObjectCollection)((StateObjectCollection)resultSubpartition.getJobManagerOwnedSnapshot()))).build();
        this.taskLocalState = OperatorSubtaskState.builder().setManagedOperatorState(StateObjectCollection.singletonOrEmpty((StateObject)operatorManaged.getTaskLocalSnapshot())).setRawOperatorState(StateObjectCollection.singletonOrEmpty((StateObject)operatorRaw.getTaskLocalSnapshot())).setManagedKeyedState(StateObjectCollection.singletonOrEmpty((StateObject)keyedManaged.getTaskLocalSnapshot())).setRawKeyedState(StateObjectCollection.singletonOrEmpty((StateObject)keyedRaw.getTaskLocalSnapshot())).setInputChannelState(StateObjectCollection.emptyIfNull((StateObjectCollection)((StateObjectCollection)inputChannel.getTaskLocalSnapshot()))).setResultSubpartitionState(StateObjectCollection.emptyIfNull((StateObjectCollection)((StateObjectCollection)resultSubpartition.getTaskLocalSnapshot()))).build();
    }

    public OperatorSubtaskState getTaskLocalState() {
        return this.taskLocalState;
    }

    public OperatorSubtaskState getJobManagerOwnedState() {
        return this.jobManagerOwnedState;
    }
}

