/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sorted.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.RunnableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointableKeyedStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupedInternalPriorityQueue;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.KeyedStateFunction;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.PriorityComparable;
import org.apache.flink.runtime.state.PriorityComparator;
import org.apache.flink.runtime.state.SavepointResources;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.streaming.api.operators.sorted.state.AbstractBatchExecutionKeyState;
import org.apache.flink.streaming.api.operators.sorted.state.BatchExecutionInternalPriorityQueueSet;
import org.apache.flink.streaming.api.operators.sorted.state.BatchExecutionKeyAggregatingState;
import org.apache.flink.streaming.api.operators.sorted.state.BatchExecutionKeyListState;
import org.apache.flink.streaming.api.operators.sorted.state.BatchExecutionKeyMapState;
import org.apache.flink.streaming.api.operators.sorted.state.BatchExecutionKeyReducingState;
import org.apache.flink.streaming.api.operators.sorted.state.BatchExecutionKeyValueState;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchExecutionKeyedStateBackend<K>
implements CheckpointableKeyedStateBackend<K> {
    private static final Logger LOG = LoggerFactory.getLogger(BatchExecutionKeyedStateBackend.class);
    private static final Map<Class<? extends StateDescriptor>, StateFactory> STATE_FACTORIES = Stream.of(Tuple2.of(ValueStateDescriptor.class, BatchExecutionKeyValueState::create), Tuple2.of(ListStateDescriptor.class, BatchExecutionKeyListState::create), Tuple2.of(MapStateDescriptor.class, BatchExecutionKeyMapState::create), Tuple2.of(AggregatingStateDescriptor.class, BatchExecutionKeyAggregatingState::create), Tuple2.of(ReducingStateDescriptor.class, BatchExecutionKeyReducingState::create)).collect(Collectors.toMap(t -> (Class)t.f0, t -> (StateFactory)t.f1));
    private K currentKey = null;
    private final TypeSerializer<K> keySerializer;
    private final List<KeyedStateBackend.KeySelectionListener<K>> keySelectionListeners = new ArrayList<KeyedStateBackend.KeySelectionListener<K>>();
    private final Map<String, State> states = new HashMap<String, State>();
    private final Map<String, KeyGroupedInternalPriorityQueue<?>> priorityQueues = new HashMap();
    private final KeyGroupRange keyGroupRange;

    public BatchExecutionKeyedStateBackend(TypeSerializer<K> keySerializer, KeyGroupRange keyGroupRange) {
        this.keySerializer = keySerializer;
        this.keyGroupRange = keyGroupRange;
    }

    public void setCurrentKey(K newKey) {
        if (!Objects.equals(newKey, this.currentKey)) {
            this.notifyKeySelected(newKey);
            for (State state : this.states.values()) {
                ((AbstractBatchExecutionKeyState)state).clearAllNamespaces();
            }
            for (KeyGroupedInternalPriorityQueue keyGroupedInternalPriorityQueue : this.priorityQueues.values()) {
                while (keyGroupedInternalPriorityQueue.poll() != null) {
                }
            }
            this.currentKey = newKey;
        }
    }

    public K getCurrentKey() {
        return this.currentKey;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public <N, S extends State, T> void applyToAllKeys(N namespace, TypeSerializer<N> namespaceSerializer, StateDescriptor<S, T> stateDescriptor, KeyedStateFunction<K, S> function) {
        LOG.debug("Not iterating over all keyed in BATCH execution mode in applyToAllKeys().");
    }

    public <N> Stream<K> getKeys(String state, N namespace) {
        LOG.debug("Returning an empty stream in BATCH execution mode in getKeys().");
        return Stream.empty();
    }

    public <N> Stream<Tuple2<K, N>> getKeysAndNamespaces(String state) {
        LOG.debug("Returning an empty stream in BATCH execution mode in getKeysAndNamespaces().");
        return Stream.empty();
    }

    public <N, S extends State, T> S getOrCreateKeyedState(TypeSerializer<N> namespaceSerializer, StateDescriptor<S, T> stateDescriptor) throws Exception {
        Object state;
        Preconditions.checkNotNull(namespaceSerializer, (String)"Namespace serializer");
        Preconditions.checkNotNull(this.keySerializer, (String)"State key serializer has not been configured in the config. This operation cannot use partitioned state.");
        if (!stateDescriptor.isSerializerInitialized()) {
            stateDescriptor.initializeSerializerUnlessSet(new ExecutionConfig());
        }
        if ((state = this.states.get(stateDescriptor.getName())) == null) {
            state = this.createState(namespaceSerializer, stateDescriptor);
            this.states.put(stateDescriptor.getName(), (State)state);
        }
        return (S)state;
    }

    public <N, S extends State> S getPartitionedState(N namespace, TypeSerializer<N> namespaceSerializer, StateDescriptor<S, ?> stateDescriptor) throws Exception {
        S state = this.getOrCreateKeyedState(namespaceSerializer, stateDescriptor);
        ((InternalKvState)state).setCurrentNamespace(namespace);
        return state;
    }

    public void dispose() {
    }

    private void notifyKeySelected(K newKey) {
        for (KeyedStateBackend.KeySelectionListener<K> keySelectionListener : this.keySelectionListeners) {
            keySelectionListener.keySelected(newKey);
        }
    }

    public void registerKeySelectionListener(KeyedStateBackend.KeySelectionListener<K> listener) {
        this.keySelectionListeners.add(listener);
    }

    public boolean deregisterKeySelectionListener(KeyedStateBackend.KeySelectionListener<K> listener) {
        return this.keySelectionListeners.remove(listener);
    }

    @Nonnull
    public <N, SV, SEV, S extends State, IS extends S> IS createInternalState(@Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull StateDescriptor<S, SV> stateDesc, @Nonnull StateSnapshotTransformer.StateSnapshotTransformFactory<SEV> snapshotTransformFactory) throws Exception {
        return this.createState(namespaceSerializer, stateDesc);
    }

    private <N, SV, S extends State, IS extends S> IS createState(@Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull StateDescriptor<S, SV> stateDesc) throws Exception {
        StateFactory stateFactory = STATE_FACTORIES.get(stateDesc.getClass());
        if (stateFactory == null) {
            String message = String.format("State %s is not supported by %s", stateDesc.getClass(), this.getClass());
            throw new FlinkRuntimeException(message);
        }
        return stateFactory.createState(this.keySerializer, namespaceSerializer, stateDesc);
    }

    @Nonnull
    public <T extends HeapPriorityQueueElement & PriorityComparable<? super T>> KeyGroupedInternalPriorityQueue<T> create(@Nonnull String stateName, @Nonnull TypeSerializer<T> byteOrderedElementSerializer) {
        KeyGroupedInternalPriorityQueue<?> priorityQueue = this.priorityQueues.get(stateName);
        if (priorityQueue == null) {
            priorityQueue = new BatchExecutionInternalPriorityQueueSet(PriorityComparator.forPriorityComparableObjects(), 128);
            this.priorityQueues.put(stateName, priorityQueue);
        }
        return priorityQueue;
    }

    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    public void close() throws IOException {
    }

    @Nonnull
    public RunnableFuture<SnapshotResult<KeyedStateHandle>> snapshot(long checkpointId, long timestamp, @Nonnull CheckpointStreamFactory streamFactory, @Nonnull CheckpointOptions checkpointOptions) {
        throw new UnsupportedOperationException("Snapshotting is not supported in BATCH runtime mode.");
    }

    @Nonnull
    public SavepointResources<K> savepoint() throws Exception {
        throw new UnsupportedOperationException("Savepoints are not supported in BATCH runtime mode.");
    }

    @FunctionalInterface
    private static interface StateFactory {
        public <T, K, N, SV, S extends State, IS extends S> IS createState(TypeSerializer<K> var1, TypeSerializer<N> var2, StateDescriptor<S, SV> var3) throws Exception;
    }
}

