/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators;

import org.apache.flink.streaming.api.functions.TimestampExtractor;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeCallback;

@Deprecated
public class ExtractTimestampsOperator<T>
extends AbstractUdfStreamOperator<T, TimestampExtractor<T>>
implements OneInputStreamOperator<T, T>,
ProcessingTimeCallback {
    private static final long serialVersionUID = 1L;
    private transient long watermarkInterval;
    private transient long currentWatermark;

    public ExtractTimestampsOperator(TimestampExtractor<T> extractor) {
        super(extractor);
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.watermarkInterval = this.getExecutionConfig().getAutoWatermarkInterval();
        if (this.watermarkInterval > 0L) {
            long now = this.getProcessingTimeService().getCurrentProcessingTime();
            this.getProcessingTimeService().registerTimer(now + this.watermarkInterval, this);
        }
        this.currentWatermark = Long.MIN_VALUE;
    }

    @Override
    public void processElement(StreamRecord<T> element) throws Exception {
        long newTimestamp = ((TimestampExtractor)this.userFunction).extractTimestamp(element.getValue(), element.getTimestamp());
        this.output.collect(element.replace(element.getValue(), newTimestamp));
        long watermark = ((TimestampExtractor)this.userFunction).extractWatermark(element.getValue(), newTimestamp);
        if (watermark > this.currentWatermark) {
            this.currentWatermark = watermark;
            this.output.emitWatermark(new Watermark(this.currentWatermark));
        }
    }

    @Override
    public void onProcessingTime(long timestamp) throws Exception {
        long newWatermark = ((TimestampExtractor)this.userFunction).getCurrentWatermark();
        if (newWatermark > this.currentWatermark) {
            this.currentWatermark = newWatermark;
            this.output.emitWatermark(new Watermark(this.currentWatermark));
        }
        long now = this.getProcessingTimeService().getCurrentProcessingTime();
        this.getProcessingTimeService().registerTimer(now + this.watermarkInterval, this);
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
        if (mark.getTimestamp() == Long.MAX_VALUE && mark.getTimestamp() > this.currentWatermark) {
            this.currentWatermark = Long.MAX_VALUE;
            this.output.emitWatermark(mark);
        }
    }
}

