/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.StreamTransformation;

@Internal
public class CoFeedbackTransformation<F>
extends StreamTransformation<F> {
    private final List<StreamTransformation<F>> feedbackEdges;
    private final Long waitTime;

    public CoFeedbackTransformation(int parallelism, TypeInformation<F> feedbackType, Long waitTime) {
        super("CoFeedback", feedbackType, parallelism);
        this.waitTime = waitTime;
        this.feedbackEdges = Lists.newArrayList();
    }

    public void addFeedbackEdge(StreamTransformation<F> transform) {
        if (transform.getParallelism() != this.getParallelism()) {
            throw new UnsupportedOperationException("Parallelism of the feedback stream must match the parallelism of the original stream. Parallelism of original stream: " + this.getParallelism() + "; parallelism of feedback stream: " + transform.getParallelism());
        }
        this.feedbackEdges.add(transform);
    }

    public List<StreamTransformation<F>> getFeedbackEdges() {
        return this.feedbackEdges;
    }

    public Long getWaitTime() {
        return this.waitTime;
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        throw new UnsupportedOperationException("Cannot set chaining strategy on Split Transformation.");
    }

    @Override
    public Collection<StreamTransformation<?>> getTransitivePredecessors() {
        return Collections.singleton(this);
    }
}

