/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.minicluster.LocalFlinkMiniCluster;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class LocalStreamEnvironment
extends StreamExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(LocalStreamEnvironment.class);
    private final Configuration conf;

    public LocalStreamEnvironment() {
        this(null);
    }

    public LocalStreamEnvironment(Configuration config) {
        if (!ExecutionEnvironment.areExplicitEnvironmentsAllowed()) {
            throw new InvalidProgramException("The LocalStreamEnvironment cannot be used when submitting a program through a client, or running in a TestEnvironment context.");
        }
        this.conf = config == null ? new Configuration() : config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        StreamGraph streamGraph = this.getStreamGraph();
        streamGraph.setJobName(jobName);
        JobGraph jobGraph = streamGraph.getJobGraph();
        Configuration configuration = new Configuration();
        configuration.addAll(jobGraph.getJobConfiguration());
        configuration.setLong("taskmanager.memory.size", -1L);
        configuration.setInteger("taskmanager.numberOfTaskSlots", jobGraph.getMaximumParallelism());
        configuration.addAll(this.conf);
        if (LOG.isInfoEnabled()) {
            LOG.info("Running job on local embedded Flink mini cluster");
        }
        LocalFlinkMiniCluster exec = new LocalFlinkMiniCluster(configuration, true);
        try {
            exec.start();
            JobExecutionResult jobExecutionResult = exec.submitJobAndWait(jobGraph, this.getConfig().isSysoutLoggingEnabled());
            return jobExecutionResult;
        }
        finally {
            this.transformations.clear();
            exec.stop();
        }
    }
}

