/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.streaming.api.windowing.assigners.DynamicEventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.SessionWindowTimeGapExtractor;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

class DynamicEventTimeSessionWindowsTest {
    DynamicEventTimeSessionWindowsTest() {
    }

    @Test
    void testWindowAssignment() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        Mockito.when((Object)extractor.extract((Object)((String)Mockito.eq((Object)"gap5000")))).thenReturn((Object)5000L);
        Mockito.when((Object)extractor.extract((Object)((String)Mockito.eq((Object)"gap4000")))).thenReturn((Object)4000L);
        Mockito.when((Object)extractor.extract((Object)((String)Mockito.eq((Object)"gap9000")))).thenReturn((Object)9000L);
        DynamicEventTimeSessionWindows assigner = DynamicEventTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"gap5000", 0L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(0L, 5000L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"gap4000", 4999L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(4999L, 8999L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"gap9000", 5000L, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(5000L, 14000L)});
    }

    @Test
    void testMergeSinglePointWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        Mockito.when((Object)extractor.extract(ArgumentMatchers.any())).thenReturn((Object)5000L);
        DynamicEventTimeSessionWindows assigner = DynamicEventTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        assigner.mergeWindows(Collections.singletonList(new TimeWindow(0L, 0L)), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).merge(ArgumentMatchers.anyCollection(), ArgumentMatchers.any());
    }

    @Test
    void testMergeSingleWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        Mockito.when((Object)extractor.extract(ArgumentMatchers.any())).thenReturn((Object)5000L);
        DynamicEventTimeSessionWindows assigner = DynamicEventTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        assigner.mergeWindows(Collections.singletonList(new TimeWindow(0L, 1L)), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).merge(ArgumentMatchers.anyCollection(), ArgumentMatchers.any());
    }

    @Test
    void testMergeConsecutiveWindows() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        Mockito.when((Object)extractor.extract(ArgumentMatchers.any())).thenReturn((Object)5000L);
        DynamicEventTimeSessionWindows assigner = DynamicEventTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        assigner.mergeWindows(Arrays.asList(new TimeWindow(0L, 1L), new TimeWindow(1L, 2L), new TimeWindow(2L, 3L), new TimeWindow(4L, 5L), new TimeWindow(5L, 6L)), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 1L), new TimeWindow(1L, 2L), new TimeWindow(2L, 3L)})), Mockito.eq((Object)new TimeWindow(0L, 3L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(4L, 5L), new TimeWindow(5L, 6L)})), Mockito.eq((Object)new TimeWindow(4L, 6L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)2))).merge(ArgumentMatchers.anyCollection(), ArgumentMatchers.any());
    }

    @Test
    void testMergeCoveringWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        Mockito.when((Object)extractor.extract(ArgumentMatchers.any())).thenReturn((Object)5000L);
        DynamicEventTimeSessionWindows assigner = DynamicEventTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        assigner.mergeWindows(Arrays.asList(new TimeWindow(1L, 1L), new TimeWindow(0L, 2L), new TimeWindow(4L, 7L), new TimeWindow(5L, 6L)), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(1L, 1L), new TimeWindow(0L, 2L)})), Mockito.eq((Object)new TimeWindow(0L, 2L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Collection)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(5L, 6L), new TimeWindow(4L, 7L)})), Mockito.eq((Object)new TimeWindow(4L, 7L)));
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)2))).merge(ArgumentMatchers.anyCollection(), ArgumentMatchers.any());
    }

    @Test
    void testInvalidParameters() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        Mockito.when((Object)extractor.extract(ArgumentMatchers.any())).thenReturn((Object)-1L);
        DynamicEventTimeSessionWindows assigner = DynamicEventTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> assigner.assignWindows(Collections.singletonList(new Object()), 1L, mockContext)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("0 < gap");
    }

    @Test
    void testProperties() {
        SessionWindowTimeGapExtractor extractor = (SessionWindowTimeGapExtractor)Mockito.mock(SessionWindowTimeGapExtractor.class);
        Mockito.when((Object)extractor.extract(ArgumentMatchers.any())).thenReturn((Object)5000L);
        DynamicEventTimeSessionWindows assigner = DynamicEventTimeSessionWindows.withDynamicGap((SessionWindowTimeGapExtractor)extractor);
        Assertions.assertThat((boolean)assigner.isEventTime()).isTrue();
        Assertions.assertThat((Object)assigner.getWindowSerializer(new ExecutionConfig())).isEqualTo((Object)new TimeWindow.Serializer());
        Assertions.assertThat((Object)assigner.getDefaultTrigger()).isInstanceOf(EventTimeTrigger.class);
    }
}

