/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.graph.NonChainedOutput;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.tasks.SourceStreamTask;
import org.apache.flink.streaming.util.TestSequentialReadingStreamOperator;

public class MockStreamConfig
extends StreamConfig {
    public MockStreamConfig(Configuration configuration, int numberOfOutputs) {
        this(configuration, numberOfOutputs, null);
    }

    public MockStreamConfig(Configuration configuration, int numberOfOutputs, @Nullable Map<Integer, StreamConfig> chainedTaskConfigs) {
        super(configuration);
        this.setChainStart();
        this.setNumberOfOutputs(numberOfOutputs);
        this.setTypeSerializerOut((TypeSerializer)new StringSerializer());
        this.setVertexID(0);
        this.setStreamOperator((StreamOperator)new TestSequentialReadingStreamOperator("test operator"));
        this.setOperatorID(new OperatorID());
        AbstractStreamOperator dummyOperator = new AbstractStreamOperator(){
            private static final long serialVersionUID = 1L;
        };
        StreamNode sourceVertex = new StreamNode(Integer.valueOf(0), null, null, (StreamOperator)dummyOperator, "source", SourceStreamTask.class);
        ArrayList<NonChainedOutput> streamOutputs = new ArrayList<NonChainedOutput>(numberOfOutputs);
        for (int i = 0; i < numberOfOutputs; ++i) {
            streamOutputs.add(new NonChainedOutput(true, sourceVertex.getId(), 1, 1, 100L, false, new IntermediateDataSetID(), null, (StreamPartitioner)new BroadcastPartitioner(), ResultPartitionType.PIPELINED_BOUNDED));
        }
        this.setVertexNonChainedOutputs(streamOutputs);
        this.setOperatorNonChainedOutputs(streamOutputs);
        if (chainedTaskConfigs != null) {
            this.setAndSerializeTransitiveChainedTaskConfigs(chainedTaskConfigs);
        }
        this.serializeAllConfigs();
    }
}

