/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.streaming.api.windowing.assigners.TumblingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.WindowStagger;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TumblingProcessingTimeWindowsTest {
    TumblingProcessingTimeWindowsTest() {
    }

    @Test
    void testWindowAssignment() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingProcessingTimeWindows assigner = TumblingProcessingTimeWindows.of((Time)Time.milliseconds((long)5000L));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)0L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(0L, 5000L)});
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)4999L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(0L, 5000L)});
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)5000L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(5000L, 10000L)});
    }

    @Test
    void testWindowAssignmentWithStagger() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingProcessingTimeWindows assigner = TumblingProcessingTimeWindows.of((Time)Time.milliseconds((long)5000L), (Time)Time.milliseconds((long)0L), (WindowStagger)WindowStagger.NATURAL);
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)150L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(150L, 5150L)});
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)5049L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(150L, 5150L)});
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)5150L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(5150L, 10150L)});
    }

    @Test
    void testWindowAssignmentWithGlobalOffset() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingProcessingTimeWindows assigner = TumblingProcessingTimeWindows.of((Time)Time.milliseconds((long)5000L), (Time)Time.milliseconds((long)100L));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)100L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(100L, 5100L)});
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)5099L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(100L, 5100L)});
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)5100L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(5100L, 10100L)});
    }

    @Test
    void testWindowAssignmentWithNegativeGlobalOffset() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingProcessingTimeWindows assigner = TumblingProcessingTimeWindows.of((Time)Time.milliseconds((long)5000L), (Time)Time.milliseconds((long)-100L));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)100L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(-100L, 4900L)});
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)4899L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(-100L, 4900L)});
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)4900L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(4900L, 9900L)});
    }

    @Test
    void testTimeUnits() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingProcessingTimeWindows assigner = TumblingProcessingTimeWindows.of((Time)Time.seconds((long)5L), (Time)Time.seconds((long)1L));
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)1000L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(1000L, 6000L)});
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)5999L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(1000L, 6000L)});
        Mockito.when((Object)mockContext.getCurrentProcessingTime()).thenReturn((Object)6000L);
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", Long.MIN_VALUE, mockContext)).containsExactly((Object[])new TimeWindow[]{new TimeWindow(6000L, 11000L)});
    }

    @Test
    void testInvalidParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TumblingProcessingTimeWindows.of((Time)Time.seconds((long)-1L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("abs(offset) < size");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TumblingProcessingTimeWindows.of((Time)Time.seconds((long)10L), (Time)Time.seconds((long)20L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("abs(offset) < size");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TumblingProcessingTimeWindows.of((Time)Time.seconds((long)10L), (Time)Time.seconds((long)-11L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("abs(offset) < size");
    }

    @Test
    void testProperties() {
        TumblingProcessingTimeWindows assigner = TumblingProcessingTimeWindows.of((Time)Time.seconds((long)5L), (Time)Time.milliseconds((long)100L));
        Assertions.assertThat((boolean)assigner.isEventTime()).isFalse();
        Assertions.assertThat((Object)assigner.getWindowSerializer(new ExecutionConfig())).isEqualTo((Object)new TimeWindow.Serializer());
        Assertions.assertThat((Object)assigner.getDefaultTrigger()).isInstanceOf(ProcessingTimeTrigger.class);
    }
}

